/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.plugin.ui;

import com.google.common.base.Preconditions;
import hudson.PluginWrapper;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.security.Permission;
import java.io.IOException;
import org.hudsonci.inject.internal.plugin.PluginClassLoader;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponentSupport<P extends Action>
implements Action {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final P parent;

    protected UIComponentSupport(P parent) {
        this.parent = parent;
    }

    protected UIComponentSupport() {
        this(null);
    }

    public P getParent() {
        return this.parent;
    }

    public String getIconFileName() {
        if (this.parent != null) {
            return this.getParent().getIconFileName();
        }
        return null;
    }

    protected String getIconFileName(String name) {
        assert (name != null);
        return String.format("/plugin/%s/images/%s", this.getPluginName(), name);
    }

    public String getUrlName() {
        return null;
    }

    protected PluginWrapper getPluginWrapper() {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof PluginClassLoader) {
            return ((PluginClassLoader)cl).getPlugin();
        }
        throw new IllegalStateException();
    }

    @JellyAccessible
    public String getRootPath() {
        StaplerRequest req = Stapler.getCurrentRequest();
        Preconditions.checkState((req != null ? 1 : 0) != 0, (Object)"StaplerRequest not bound");
        return req.getContextPath();
    }

    @JellyAccessible
    public String getPluginName() {
        return this.getPluginWrapper().getShortName();
    }

    @JellyAccessible
    public String getPluginPath() {
        return String.format("%s/plugin/%s", this.getRootPath(), this.getPluginName());
    }

    @JellyAccessible
    public String getImagesPath() {
        return String.format("%s/images", this.getPluginPath());
    }

    @JellyAccessible
    public String getHelpPath() {
        return String.format("/plugin/%s/help", this.getPluginName());
    }

    @JellyAccessible
    public String getIconPath() {
        String iconPath = this.getIconFileName();
        if (iconPath.startsWith("/")) {
            iconPath = iconPath.substring(1, iconPath.length());
        }
        return String.format("%s/%s", this.getRootPath(), iconPath);
    }

    @JellyAccessible
    public Object getSidePanelOwner() {
        if (this.parent instanceof UIComponentSupport) {
            return ((UIComponentSupport)this.parent).getSidePanelOwner();
        }
        return this.parent;
    }

    @JellyAccessible
    public Permission getViewPermission() {
        return Hudson.READ;
    }

    @JellyAccessible
    public String getPageTitle() {
        return this.getDisplayName();
    }

    protected void checkPermission(Permission perm) {
        Hudson.getInstance().checkPermission(perm);
    }

    protected void redirect(StaplerRequest req, StaplerResponse resp, String location) throws IOException {
        this.log.trace("Redirecting to: {}", (Object)location);
        resp.sendRedirect(location);
    }

    protected void redirectAncestor(StaplerRequest req, StaplerResponse resp, Class type) throws IOException {
        this.log.trace("Redirect ancestor: {}", (Object)type);
        this.redirect(req, resp, req.findAncestor(type).getUrl());
    }

    protected void redirectAncestor(StaplerRequest req, StaplerResponse resp, Object obj) throws IOException {
        this.log.trace("Redirect ancestor: {}", obj);
        Ancestor ancestor = req.findAncestor(obj);
        this.redirect(req, resp, ancestor.getUrl());
    }

    protected void redirectParent(StaplerRequest req, StaplerResponse resp) throws IOException {
        this.redirectAncestor(req, resp, this.getParent());
    }

    protected void redirectSelf(StaplerRequest req, StaplerResponse resp) throws IOException {
        this.redirectAncestor(req, resp, this);
    }

    @JellyAccessible
    public String getBaseRestURI() {
        return String.format("%s/rest/plugin/%s", this.getRootPath(), this.getPluginName());
    }
}

