/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import hudson.PluginManager;
import hudson.TcpSlaveAgentListener;
import hudson.model.FingerprintMap;
import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.model.User;
import hudson.security.SecurityRealm;
import javax.inject.Named;

public class HudsonModule
extends AbstractModule {
    private static final ReflectionProvider reflection = new JVM().bestReflectionProvider();
    private static PluginManager plugins;

    protected void configure() {
        this.bind(ReflectionProvider.class).toInstance((Object)reflection);
    }

    @Provides
    private Hudson getHudson() {
        Hudson hudson = Hudson.getInstance();
        Preconditions.checkState((hudson != null ? 1 : 0) != 0);
        return hudson;
    }

    public static void bind(PluginManager plugins) {
        HudsonModule.plugins = (PluginManager)Preconditions.checkNotNull((Object)plugins);
    }

    @Provides
    private PluginManager getPluginManager() {
        PluginManager target = plugins != null ? plugins : this.getHudson().getPluginManager();
        Preconditions.checkState((target != null ? 1 : 0) != 0);
        return target;
    }

    @Provides
    private SecurityRealm getSecurityRealm() {
        return this.getHudson().getSecurityRealm();
    }

    @Provides
    private Queue getQueue() {
        return this.getHudson().getQueue();
    }

    @Provides
    private TcpSlaveAgentListener getTcpSlaveAgentListener() {
        return this.getHudson().getTcpSlaveAgentListener();
    }

    @Provides
    private FingerprintMap getFingerprintMap() {
        return this.getHudson().getFingerprintMap();
    }

    @Provides
    @Named(value="current")
    private User getCurrentUser() {
        return User.current();
    }
}

