/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.injecto.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.spi.InjectionPoint;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.inject.SmoothieContainer;
import org.hudsonci.inject.injecto.Injectable;
import org.hudsonci.inject.injecto.Injectomatic;
import org.hudsonci.inject.internal.OID;
import org.hudsonci.inject.internal.SmoothieContainerImpl;
import org.hudsonci.inject.internal.plugin.PluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class InjectomaticImpl
implements Injectomatic {
    private static final Logger log = LoggerFactory.getLogger(InjectomaticImpl.class);
    private final SmoothieContainer container;
    private final Set<Class> registered = new HashSet<Class>();
    private final Set<Class> injectable = new HashSet<Class>();
    private final Set<Class> nonInjectable = new HashSet<Class>();

    @Inject
    public InjectomaticImpl(SmoothieContainer container) {
        this.container = (SmoothieContainer)Preconditions.checkNotNull((Object)container);
        this.register(Injectable.class);
    }

    public void register(Class type) {
        Preconditions.checkNotNull((Object)type);
        log.debug("Registering type: {}", (Object)type);
        this.registered.add(type);
    }

    public boolean isInjectable(Class type) {
        Preconditions.checkNotNull((Object)type);
        if (this.injectable.contains(type)) {
            return true;
        }
        if (this.nonInjectable.contains(type)) {
            return false;
        }
        for (Class rtype : this.registered) {
            if (!rtype.isAssignableFrom(type) || InjectionPoint.forInstanceMethodsAndFields((Class)type).isEmpty()) continue;
            this.injectable.add(type);
            log.trace("Detected injectable type: {}", (Object)type);
            return true;
        }
        this.nonInjectable.add(type);
        return false;
    }

    public void inject(Object component) {
        Injector injector;
        Preconditions.checkNotNull((Object)component);
        Class<?> type = component.getClass();
        if (!this.isInjectable(type)) {
            log.trace("Type not injectable; skipping: {}", type);
            return;
        }
        ClassLoader tmp = type.getClassLoader();
        if (tmp instanceof PluginClassLoader) {
            PluginClassLoader cl = (PluginClassLoader)((Object)tmp);
            injector = this.container.injector(cl.getPlugin());
        } else {
            injector = ((SmoothieContainerImpl)this.container).rootInjector();
        }
        if (log.isTraceEnabled()) {
            log.trace("Injecting: {}", (Object)OID.get(component));
        }
        injector.injectMembers(component);
    }
}

