/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.util.converter;

import com.thalesgroup.dtkit.util.converter.ConversionException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Serializable;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;

public class ConversionService
implements Serializable {
    public void convert(File xslFile, File inputFile, File outFile) throws ConversionException {
        try {
            this.convert(new StreamSource(new FileReader(xslFile)), inputFile, outFile);
        }
        catch (FileNotFoundException e) {
            throw new ConversionException("Can't find " + xslFile);
        }
    }

    public void convert(Class xslNamespace, String xslName, File inputFile, File outFile) throws ConversionException {
        this.convert(new StreamSource(xslNamespace.getResourceAsStream(xslName)), inputFile, outFile);
    }

    private void convert(StreamSource xslSource, File inputFile, File outFile) throws ConversionException {
        try {
            Processor processor = new Processor(false);
            XsltCompiler compiler = processor.newXsltCompiler();
            XsltExecutable xsltExecutable = compiler.compile((Source)xslSource);
            XsltTransformer xsltTransformer = xsltExecutable.load();
            XdmNode xdmNode = processor.newDocumentBuilder().build(inputFile);
            Serializer out = new Serializer();
            out.setOutputProperty(Serializer.Property.METHOD, "xml");
            out.setOutputProperty(Serializer.Property.INDENT, "yes");
            out.setOutputStream((OutputStream)new FileOutputStream(outFile));
            xsltTransformer.setInitialContextNode(xdmNode);
            xsltTransformer.setDestination((Destination)out);
            xsltTransformer.transform();
        }
        catch (FileNotFoundException fne) {
            throw new ConversionException("Error to convert - A file not found", fne);
        }
        catch (SaxonApiException sae) {
            throw new ConversionException("Error to convert the input XML document", sae);
        }
    }
}

