/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.util.validator;

import com.thalesgroup.dtkit.util.validator.ValidationError;
import com.thalesgroup.dtkit.util.validator.ValidationException;
import com.thalesgroup.dtkit.util.validator.ValidationHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationService {
    public List<ValidationError> processValidation(Class xsdNamespace, String xsdName, File inputXML) throws ValidationException {
        if (xsdName == null) {
            return new ArrayList<ValidationError>();
        }
        ValidationHandler handler = new ValidationHandler();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(handler);
            Schema schemaGrammar = schemaFactory.newSchema(xsdNamespace.getResource(xsdName));
            Validator schemaValidator = schemaGrammar.newValidator();
            schemaValidator.setErrorHandler(handler);
            schemaValidator.validate(new StreamSource(inputXML));
            return handler.getErrors();
        }
        catch (SAXException sae) {
            return handler.getErrors();
        }
        catch (IOException ioe) {
            throw new ValidationException("Validation error", ioe);
        }
    }
}

