/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.util.validator;

import com.thalesgroup.dtkit.util.validator.ValidatorError;
import com.thalesgroup.dtkit.util.validator.ValidatorException;
import com.thalesgroup.dtkit.util.validator.ValidatorHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorUtil {
    public static List<ValidatorError> processValidation(Class xsdNamnespace, String xsdName, File inputXML) throws ValidatorException {
        if (xsdName == null) {
            return new ArrayList<ValidatorError>();
        }
        ValidatorHandler handler = new ValidatorHandler();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(handler);
            Schema schemaGrammar = schemaFactory.newSchema(xsdNamnespace.getResource(xsdName));
            Resolver resolver = new Resolver();
            Validator schemaValidator = schemaGrammar.newValidator();
            schemaValidator.setResourceResolver(resolver);
            schemaValidator.setErrorHandler(handler);
            schemaValidator.validate(new StreamSource(inputXML));
            return handler.getErrors();
        }
        catch (SAXException saxException) {
            return handler.getErrors();
        }
        catch (IOException ioException) {
            return handler.getErrors();
        }
    }

    protected static class Resolver
    implements LSResourceResolver {
        protected Resolver() {
        }

        public LSInput resolveResource(String type, String namespace, String publicId, String systemId, String baseURI) {
            return null;
        }
    }
}

