/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.util.converter;

import com.thalesgroup.dtkit.util.converter.ConvertException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;

public class ConvertUtil {
    public static void convert(Class xslNamnespace, String xslName, File inputFile, File outFile) throws ConvertException {
        try {
            Processor processor = new Processor(false);
            XsltCompiler compiler = processor.newXsltCompiler();
            XsltExecutable xsltExecutable = compiler.compile((Source)new StreamSource(xslNamnespace.getResourceAsStream(xslName)));
            XsltTransformer xsltTransformer = xsltExecutable.load();
            XdmNode xdmNode = processor.newDocumentBuilder().build(inputFile);
            Serializer out = new Serializer();
            out.setOutputProperty(Serializer.Property.METHOD, "xml");
            out.setOutputProperty(Serializer.Property.INDENT, "yes");
            out.setOutputStream((OutputStream)new FileOutputStream(outFile));
            xsltTransformer.setInitialContextNode(xdmNode);
            xsltTransformer.setDestination((Destination)out);
            xsltTransformer.transform();
        }
        catch (FileNotFoundException fne) {
            throw new ConvertException("Error to convert - A file not found", fne);
        }
        catch (SaxonApiException saie) {
            throw new ConvertException("Error to convert the input XML document with the stylesheet '" + xslName + "'", saie);
        }
    }
}

