/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.util.converter;

import com.thalesgroup.dtkit.util.converter.ConversionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionService
implements Serializable {
    public String convertAndReturn(File xslFile, InputSource inputFile, Map<String, Object> params) throws ConversionException {
        try {
            FileReader reader = new FileReader(xslFile);
            String result = this.convertAndReturn(new StreamSource(reader), inputFile, params);
            ((Reader)reader).close();
            return result;
        }
        catch (IOException ioe) {
            throw new ConversionException("Conversion Error", ioe);
        }
    }

    public String convertAndReturn(File xslFile, File inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        FileInputStream fis = null;
        try {
            FileReader reader = new FileReader(xslFile);
            fis = new FileInputStream(inputFile);
            String result = this.convertAndReturn(new StreamSource(reader), new InputSource(fis), params);
            ((Reader)reader).close();
            String string = result;
            return string;
        }
        catch (FileNotFoundException fne) {
            throw new ConversionException(fne);
        }
        catch (IOException ioe) {
            throw new ConversionException("Conversion Error", ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new ConversionException(ioe);
                }
            }
        }
    }

    public void convert(File xslFile, File inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        try {
            FileReader reader = new FileReader(xslFile);
            this.convert(new StreamSource(reader), inputFile, outFile, params);
            ((Reader)reader).close();
        }
        catch (IOException ioe) {
            throw new ConversionException("Conversion Error", ioe);
        }
    }

    public void convert(File xslFile, File inputFile, File outFile) throws ConversionException {
        this.convert(xslFile, inputFile, outFile, null);
    }

    public String convertAndReturn(StreamSource xslSource, File inputFile, Map<String, Object> params) throws ConversionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(inputFile);
            String string = this.convertAndReturn(xslSource, new InputSource(fis), params);
            return string;
        }
        catch (FileNotFoundException fne) {
            throw new ConversionException(fne);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new ConversionException(ioe);
                }
            }
        }
    }

    public void convert(StreamSource xslSource, File inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(inputFile);
            this.convert(xslSource, new InputSource(fis), outFile, params);
        }
        catch (FileNotFoundException fne) {
            throw new ConversionException(fne);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new ConversionException(ioe);
                }
            }
        }
    }

    public void convert(File xslFile, InputSource inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        try {
            FileReader reader = new FileReader(xslFile);
            this.convert(new StreamSource(reader), inputFile, outFile, params);
            ((Reader)reader).close();
        }
        catch (IOException ioe) {
            throw new ConversionException("Conversion Error", ioe);
        }
    }

    public String convertAndReturn(StreamSource xslSource, InputSource inputFile, Map<String, Object> params) throws ConversionException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = builder.parse(inputFile);
            DOMSource source = new DOMSource(document.getDocumentElement());
            Processor processor = new Processor(false);
            XsltCompiler compiler = processor.newXsltCompiler();
            XsltExecutable xsltExecutable = compiler.compile((Source)xslSource);
            XsltTransformer xsltTransformer = xsltExecutable.load();
            net.sf.saxon.s9api.DocumentBuilder documentBuilder = processor.newDocumentBuilder();
            documentBuilder.setDTDValidation(false);
            XdmNode xdmNode = documentBuilder.build((Source)source);
            Serializer out = new Serializer();
            out.setOutputProperty(Serializer.Property.METHOD, "xml");
            out.setOutputProperty(Serializer.Property.INDENT, "yes");
            File fileOut = File.createTempFile("serializer", "convert");
            FileOutputStream fos = new FileOutputStream(fileOut);
            out.setOutputStream((OutputStream)fos);
            xsltTransformer.setInitialContextNode(xdmNode);
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    QName paramName = new QName(entry.getKey());
                    XdmAtomicValue paramValue = new XdmAtomicValue(String.valueOf(entry.getValue()));
                    xsltTransformer.setParameter(paramName, (XdmValue)paramValue);
                }
            }
            xsltTransformer.setDestination((Destination)out);
            xsltTransformer.transform();
            FileReader reader = new FileReader(fileOut);
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            ((Reader)reader).close();
            bufferedReader.close();
            fos.close();
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new ConversionException("Error to convert - A file not found", ioe);
        }
        catch (SaxonApiException sae) {
            throw new ConversionException("Error to convert the input XML document", sae);
        }
        catch (SAXException sae) {
            throw new ConversionException("Error to convert - A file not found", sae);
        }
        catch (ParserConfigurationException pe) {
            throw new ConversionException("Error to convert - A file not found", pe);
        }
    }

    public void convert(StreamSource xslSource, InputSource inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = builder.parse(inputFile);
            DOMSource source = new DOMSource(document.getDocumentElement());
            Processor processor = new Processor(false);
            XsltCompiler compiler = processor.newXsltCompiler();
            XsltExecutable xsltExecutable = compiler.compile((Source)xslSource);
            XsltTransformer xsltTransformer = xsltExecutable.load();
            net.sf.saxon.s9api.DocumentBuilder documentBuilder = processor.newDocumentBuilder();
            documentBuilder.setDTDValidation(false);
            XdmNode xdmNode = documentBuilder.build((Source)source);
            Serializer out = new Serializer();
            out.setOutputProperty(Serializer.Property.METHOD, "xml");
            out.setOutputProperty(Serializer.Property.INDENT, "yes");
            FileOutputStream fos = new FileOutputStream(outFile);
            out.setOutputStream((OutputStream)fos);
            xsltTransformer.setInitialContextNode(xdmNode);
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    QName paramName = new QName(entry.getKey());
                    XdmAtomicValue paramValue = new XdmAtomicValue(String.valueOf(entry.getValue()));
                    xsltTransformer.setParameter(paramName, (XdmValue)paramValue);
                }
            }
            xsltTransformer.setDestination((Destination)out);
            xsltTransformer.transform();
            fos.close();
        }
        catch (IOException ioe) {
            throw new ConversionException("Error to convert - A file not found", ioe);
        }
        catch (SaxonApiException sae) {
            throw new ConversionException("Error to convert the input XML document", sae);
        }
        catch (SAXException sae) {
            throw new ConversionException("Error to convert - A file not found", sae);
        }
        catch (ParserConfigurationException pe) {
            throw new ConversionException("Error to convert - A file not found", pe);
        }
    }

    public void convert(StreamSource xslSource, File inputFile, File outFile) throws ConversionException {
        this.convert(xslSource, inputFile, outFile, null);
    }
}

