/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.util.validator;

import com.thalesgroup.dtkit.util.validator.ValidationError;
import com.thalesgroup.dtkit.util.validator.ValidationException;
import com.thalesgroup.dtkit.util.validator.ValidationHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationService
implements Serializable {
    public List<ValidationError> processValidation(Source xsdSource, File inputXML) throws ValidationException {
        return this.processValidation(new Source[]{xsdSource}, inputXML);
    }

    public List<ValidationError> processValidation(File[] xsdFiles, File inputXML) throws ValidationException {
        int i;
        Source[] xsdSources = new Source[xsdFiles.length];
        Reader[] readers = new Reader[xsdFiles.length];
        for (i = 0; i < xsdFiles.length; ++i) {
            try {
                readers[i] = new FileReader(xsdFiles[i]);
                continue;
            }
            catch (FileNotFoundException fne) {
                throw new ValidationException("Validation error", fne);
            }
        }
        for (i = 0; i < readers.length; ++i) {
            xsdSources[i] = new StreamSource(readers[i]);
        }
        List<ValidationError> listErrors = this.processValidation(xsdSources, inputXML);
        for (int i2 = 0; i2 < readers.length; ++i2) {
            try {
                readers[i2].close();
                continue;
            }
            catch (IOException ioe) {
                throw new ValidationException("Validation error", ioe);
            }
        }
        return listErrors;
    }

    public List<ValidationError> processValidation(Source[] xsdSources, File inputXML) throws ValidationException {
        ValidationHandler handler = new ValidationHandler();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(handler);
            Schema schemaGrammar = schemaFactory.newSchema(xsdSources);
            Resolver resolver = new Resolver();
            Validator schemaValidator = schemaGrammar.newValidator();
            schemaValidator.setErrorHandler(handler);
            schemaValidator.setResourceResolver(resolver);
            schemaValidator.validate(new StreamSource(inputXML));
            for (int i = 0; i < xsdSources.length; ++i) {
                xsdSources[i] = null;
            }
            return handler.getErrors();
        }
        catch (SAXException sae) {
            return handler.getErrors();
        }
        catch (IOException ioe) {
            throw new ValidationException("Validation error", ioe);
        }
    }

    public List<ValidationError> processValidation(File xsdFile, File inputXML) throws ValidationException {
        return this.processValidation(new StreamSource(xsdFile), inputXML);
    }

    protected static class Resolver
    implements LSResourceResolver {
        protected Resolver() {
        }

        public LSInput resolveResource(String type, String namespace, String publicId, String systemId, String baseURI) {
            return null;
        }
    }
}

