/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.util.converter;

import com.thalesgroup.dtkit.util.converter.ConversionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConversionService
implements Serializable {
    public void convert(File xslFile, File inputFile, File outFile) throws ConversionException {
        try {
            FileReader reader = new FileReader(xslFile);
            this.convert(new StreamSource(reader), inputFile, outFile);
            ((Reader)reader).close();
        }
        catch (IOException ioe) {
            throw new ConversionException("Conversion Error", ioe);
        }
    }

    public void convert(StreamSource xslSource, File inputFile, File outFile) throws ConversionException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = builder.parse(inputFile);
            DOMSource source = new DOMSource(document.getDocumentElement());
            Processor processor = new Processor(false);
            XsltCompiler compiler = processor.newXsltCompiler();
            XsltExecutable xsltExecutable = compiler.compile((Source)xslSource);
            XsltTransformer xsltTransformer = xsltExecutable.load();
            net.sf.saxon.s9api.DocumentBuilder documentBuilder = processor.newDocumentBuilder();
            documentBuilder.setDTDValidation(false);
            XdmNode xdmNode = documentBuilder.build((Source)source);
            Serializer out = new Serializer();
            out.setOutputProperty(Serializer.Property.METHOD, "xml");
            out.setOutputProperty(Serializer.Property.INDENT, "yes");
            FileOutputStream fos = new FileOutputStream(outFile);
            out.setOutputStream((OutputStream)fos);
            xsltTransformer.setInitialContextNode(xdmNode);
            xsltTransformer.setDestination((Destination)out);
            xsltTransformer.transform();
            fos.close();
        }
        catch (IOException ioe) {
            throw new ConversionException("Error to convert - A file not found", ioe);
        }
        catch (SaxonApiException sae) {
            throw new ConversionException("Error to convert the input XML document", sae);
        }
        catch (SAXException sae) {
            throw new ConversionException("Error to convert - A file not found", sae);
        }
        catch (ParserConfigurationException pe) {
            throw new ConversionException("Error to convert - A file not found", pe);
        }
    }
}

