/*
 * Decompiled with CFR 0.152.
 */
package org.junit.support.testng.engine;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.junit.support.testng.engine.ClassDescriptor;
import org.junit.support.testng.engine.TestDescriptorFactory;

class TestNGSelectorResolver
implements SelectorResolver {
    private final Predicate<String> classNameFilter;
    private final TestDescriptorFactory testDescriptorFactory;

    TestNGSelectorResolver(Predicate<String> classNameFilter, TestDescriptorFactory testDescriptorFactory) {
        this.classNameFilter = classNameFilter;
        this.testDescriptorFactory = testDescriptorFactory;
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        if (!this.classNameFilter.test(selector.getClassName())) {
            return SelectorResolver.Resolution.unresolved();
        }
        return context.addToParent(parent -> Optional.of(this.testDescriptorFactory.createClassDescriptor((TestDescriptor)parent, selector.getJavaClass()))).map(classDescriptor -> SelectorResolver.Match.exact((TestDescriptor)classDescriptor, () -> {
            classDescriptor.selectEntireClass();
            return Collections.emptySet();
        })).map(SelectorResolver.Resolution::match).orElse(SelectorResolver.Resolution.unresolved());
    }

    public SelectorResolver.Resolution resolve(MethodSelector selector, SelectorResolver.Context context) {
        return context.resolve((DiscoverySelector)DiscoverySelectors.selectClass((Class)selector.getJavaClass())).map(parent -> {
            ((ClassDescriptor)((Object)parent)).includeTestMethod(selector.getMethodName());
            return parent;
        }).map(SelectorResolver.Match::partial).map(SelectorResolver.Resolution::match).orElse(SelectorResolver.Resolution.unresolved());
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        UniqueId.Segment lastSegment = uniqueId.getLastSegment();
        if ("class".equals(lastSegment.getType())) {
            return SelectorResolver.Resolution.selectors(Collections.singleton(DiscoverySelectors.selectClass((String)lastSegment.getValue())));
        }
        if ("method".equals(lastSegment.getType())) {
            UniqueId.Segment previousSegment;
            String methodName = lastSegment.getValue();
            int i = methodName.indexOf(40);
            if (i != -1) {
                methodName = methodName.substring(0, i);
            }
            if ("class".equals((previousSegment = uniqueId.removeLastSegment().getLastSegment()).getType())) {
                String className = previousSegment.getValue();
                return SelectorResolver.Resolution.selectors(Collections.singleton(DiscoverySelectors.selectMethod((String)className, (String)methodName)));
            }
        }
        if ("invoc".equals(lastSegment.getType())) {
            return SelectorResolver.Resolution.selectors(Collections.singleton(DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment())));
        }
        return SelectorResolver.Resolution.unresolved();
    }
}

