/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.9")
public class OutputDir {
    private static final Pattern OUTPUT_DIR_UNIQUE_NUMBER_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("{uniqueNumber}"));
    private final Path path;
    private final SecureRandom random;

    public static OutputDir create(Optional<String> customDir) {
        return OutputDir.create(customDir, () -> Path.of(".", new String[0]));
    }

    static OutputDir create(Optional<String> customDir, Supplier<Path> currentWorkingDir) {
        try {
            return OutputDir.createSafely(customDir, currentWorkingDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output dir", e);
        }
    }

    static OutputDir createSafely(Optional<String> customDir, Supplier<Path> currentWorkingDir) throws IOException {
        return OutputDir.createSafely(customDir, currentWorkingDir, new SecureRandom());
    }

    private static OutputDir createSafely(Optional<String> customDir, Supplier<Path> currentWorkingDir, SecureRandom random) throws IOException {
        Path outputDir;
        Path cwd = currentWorkingDir.get().toAbsolutePath();
        if (customDir.isPresent() && StringUtils.isNotBlank((String)customDir.get())) {
            String customPath = customDir.get();
            while (customPath.contains("{uniqueNumber}")) {
                customPath = OUTPUT_DIR_UNIQUE_NUMBER_PLACEHOLDER_PATTERN.matcher(customPath).replaceFirst(String.valueOf(Math.abs(random.nextLong())));
            }
            outputDir = cwd.resolve(customPath);
        } else {
            outputDir = Files.exists(cwd.resolve("pom.xml"), new LinkOption[0]) ? cwd.resolve("target") : (OutputDir.containsFilesWithExtensions(cwd, ".gradle", ".gradle.kts") ? cwd.resolve("build") : cwd);
        }
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        return new OutputDir(outputDir.normalize(), random);
    }

    private OutputDir(Path path, SecureRandom random) {
        this.path = path;
        this.random = random;
    }

    public Path toPath() {
        return this.path;
    }

    public Path createFile(String prefix, String extension) throws UncheckedIOException {
        String filename = "%s-%d.%s".formatted(prefix, Math.abs(this.random.nextLong()), extension);
        Path outputFile = this.path.resolve(filename);
        try {
            if (Files.exists(outputFile, new LinkOption[0])) {
                Files.delete(outputFile);
            }
            return Files.createFile(outputFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output file: " + String.valueOf(outputFile), e);
        }
    }

    private static boolean containsFilesWithExtensions(Path dir, String ... extensions) throws IOException {
        BiPredicate<Path, BasicFileAttributes> matcher = (path, basicFileAttributes) -> {
            if (basicFileAttributes.isRegularFile()) {
                for (String extension : extensions) {
                    if (!path.getFileName().toString().endsWith(extension)) continue;
                    return true;
                }
            }
            return false;
        };
        try (Stream<Path> pathStream = Files.find(dir, 1, matcher, new FileVisitOption[0]);){
            boolean bl = pathStream.findFirst().isPresent();
            return bl;
        }
    }
}

