/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.SelectorResolutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.DirectorySource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.descriptor.PackageSource;
import org.junit.platform.engine.support.descriptor.UriSource;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.core.DiscoveryIssueNotifier;

class DiscoveryIssueCollector
implements LauncherDiscoveryListener {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryIssueCollector.class);
    final List<DiscoveryIssue> issues = new ArrayList<DiscoveryIssue>();
    private final ConfigurationParameters configurationParameters;

    DiscoveryIssueCollector(ConfigurationParameters configurationParameters) {
        this.configurationParameters = configurationParameters;
    }

    @Override
    public void engineDiscoveryStarted(UniqueId engineId) {
        this.issues.clear();
    }

    public void selectorProcessed(UniqueId engineId, DiscoverySelector selector, SelectorResolutionResult result) {
        UniqueIdSelector uniqueIdSelector;
        UniqueId uniqueId;
        if (result.getStatus() == SelectorResolutionResult.Status.FAILED) {
            this.issues.add(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.ERROR, (String)(String.valueOf(selector) + " resolution failed")).cause(result.getThrowable()).source(DiscoveryIssueCollector.toSource(selector)).build());
        } else if (result.getStatus() == SelectorResolutionResult.Status.UNRESOLVED && selector instanceof UniqueIdSelector && (uniqueId = (uniqueIdSelector = (UniqueIdSelector)selector).getUniqueId()).hasPrefix(engineId)) {
            this.issues.add(DiscoveryIssue.create((DiscoveryIssue.Severity)DiscoveryIssue.Severity.ERROR, (String)(String.valueOf(selector) + " could not be resolved")));
        }
    }

    static @Nullable TestSource toSource(DiscoverySelector selector) {
        if (selector instanceof ClassSelector) {
            ClassSelector classSelector = (ClassSelector)selector;
            return ClassSource.from((String)classSelector.getClassName());
        }
        if (selector instanceof MethodSelector) {
            MethodSelector methodSelector = (MethodSelector)selector;
            return MethodSource.from((String)methodSelector.getClassName(), (String)methodSelector.getMethodName(), (String)methodSelector.getParameterTypeNames());
        }
        if (selector instanceof ClasspathResourceSelector) {
            ClasspathResourceSelector resourceSelector = (ClasspathResourceSelector)selector;
            String resourceName = resourceSelector.getClasspathResourceName();
            return (TestSource)resourceSelector.getPosition().map(DiscoveryIssueCollector::convert).map(position -> ClasspathResourceSource.from((String)resourceName, (FilePosition)position)).orElseGet(() -> ClasspathResourceSource.from((String)resourceName));
        }
        if (selector instanceof PackageSelector) {
            PackageSelector packageSelector = (PackageSelector)selector;
            return PackageSource.from((String)packageSelector.getPackageName());
        }
        if (selector instanceof FileSelector) {
            FileSelector fileSelector = (FileSelector)selector;
            return (TestSource)fileSelector.getPosition().map(DiscoveryIssueCollector::convert).map(position -> FileSource.from((File)fileSelector.getFile(), (FilePosition)position)).orElseGet(() -> FileSource.from((File)fileSelector.getFile()));
        }
        if (selector instanceof DirectorySelector) {
            DirectorySelector directorySelector = (DirectorySelector)selector;
            return DirectorySource.from((File)directorySelector.getDirectory());
        }
        if (selector instanceof UriSelector) {
            UriSelector uriSelector = (UriSelector)selector;
            return UriSource.from((URI)uriSelector.getUri());
        }
        return null;
    }

    private static FilePosition convert(org.junit.platform.engine.discovery.FilePosition position) {
        return position.getColumn().map(column -> FilePosition.from((int)position.getLine(), (int)column)).orElseGet(() -> FilePosition.from((int)position.getLine()));
    }

    public void issueEncountered(UniqueId engineId, DiscoveryIssue issue) {
        this.issues.add(issue);
    }

    DiscoveryIssueNotifier toNotifier() {
        if (this.issues.isEmpty()) {
            return DiscoveryIssueNotifier.NO_ISSUES;
        }
        return DiscoveryIssueNotifier.from(this.getCriticalSeverity(), this.issues);
    }

    private DiscoveryIssue.Severity getCriticalSeverity() {
        DiscoveryIssue.Severity defaultValue = DiscoveryIssue.Severity.ERROR;
        return this.configurationParameters.get("junit.platform.discovery.issue.severity.critical", value -> {
            try {
                return DiscoveryIssue.Severity.valueOf((String)value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                logger.warn(() -> String.format("Invalid DiscoveryIssue.Severity '%s' set via the '%s' configuration parameter. Falling back to the %s default value.", value, "junit.platform.discovery.issue.severity.critical", defaultValue));
                return defaultValue;
            }
        }).orElse(defaultValue);
    }
}

