/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.TestEngine;

class ServiceLoaderTestEngineRegistry {
    private static final Logger logger = Logger.getLogger(ServiceLoaderTestEngineRegistry.class.getName());

    ServiceLoaderTestEngineRegistry() {
    }

    public Iterable<TestEngine> loadTestEngines() {
        ServiceLoader<TestEngine> testEngines = ServiceLoader.load(TestEngine.class, ClassLoaderUtils.getDefaultClassLoader());
        logger.config(() -> this.createDiscoveredTestEnginesMessage(testEngines));
        return testEngines;
    }

    private String createDiscoveredTestEnginesMessage(Iterable<TestEngine> testEngines) {
        List details = CollectionUtils.toStream(testEngines).map(engine -> String.format("%s (%s)", engine.getId(), String.join((CharSequence)", ", this.computeAttributes((TestEngine)engine)))).collect(Collectors.toList());
        return details.isEmpty() ? "No TestEngine implementation discovered." : "Discovered TestEngines with IDs: [" + String.join((CharSequence)", ", details) + "]";
    }

    private List<String> computeAttributes(TestEngine engine) {
        ArrayList<String> attributes = new ArrayList<String>(4);
        engine.getGroupId().ifPresent(groupId -> attributes.add("group ID: " + groupId));
        engine.getArtifactId().ifPresent(artifactId -> attributes.add("artifact ID: " + artifactId));
        engine.getVersion().ifPresent(version -> attributes.add("version: " + version));
        ClassLoaderUtils.getLocation((Object)engine).ifPresent(location -> attributes.add("location: " + location));
        return attributes;
    }
}

