/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.jfr;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.Relational;
import jdk.jfr.StackTrace;
import org.apiguardian.api.API;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@API(status=API.Status.EXPERIMENTAL, since="1.7")
public class FlightRecordingListener
implements TestExecutionListener {
    private final AtomicReference<TestPlanExecutionEvent> testPlanExecutionEvent = new AtomicReference();
    private final Map<String, TestExecutionEvent> testExecutionEventMap = new ConcurrentHashMap<String, TestExecutionEvent>();

    public void testPlanExecutionStarted(TestPlan plan) {
        TestPlanExecutionEvent event = new TestPlanExecutionEvent();
        event.containsTests = plan.containsTests();
        event.engineNames = plan.getRoots().stream().map(TestIdentifier::getDisplayName).collect(Collectors.joining(", "));
        this.testPlanExecutionEvent.set(event);
        event.begin();
    }

    public void testPlanExecutionFinished(TestPlan plan) {
        TestPlanExecutionEvent event = this.testPlanExecutionEvent.get();
        event.commit();
    }

    public void executionSkipped(TestIdentifier test, String reason) {
        SkippedTestEvent event = new SkippedTestEvent();
        event.initialize(test);
        event.reason = reason;
        event.commit();
    }

    public void executionStarted(TestIdentifier test) {
        TestExecutionEvent event = new TestExecutionEvent();
        this.testExecutionEventMap.put(test.getUniqueId(), event);
        event.initialize(test);
        event.begin();
    }

    public void executionFinished(TestIdentifier test, TestExecutionResult result) {
        if (test.isContainer() && result.getStatus().equals((Object)TestExecutionResult.Status.SUCCESSFUL)) {
            return;
        }
        Optional throwable = result.getThrowable();
        TestExecutionEvent event = this.testExecutionEventMap.get(test.getUniqueId());
        event.end();
        event.result = result.getStatus().toString();
        event.exceptionClass = throwable.map(Object::getClass).orElse(null);
        event.exceptionMessage = throwable.map(Throwable::getMessage).orElse(null);
        event.commit();
    }

    public void reportingEntryPublished(TestIdentifier test, ReportEntry reportEntry) {
        for (Map.Entry entry : reportEntry.getKeyValuePairs().entrySet()) {
            ReportEntryEvent event = new ReportEntryEvent();
            event.uniqueId = test.getUniqueId();
            event.key = (String)entry.getKey();
            event.value = (String)entry.getValue();
            event.commit();
        }
    }

    @Category(value={"JUnit"})
    @Label(value="Report Entry")
    @Name(value="org.junit.ReportEntry")
    @StackTrace(value=false)
    static class ReportEntryEvent
    extends Event {
        @UniqueId
        @Label(value="Unique Id")
        String uniqueId;
        @Label(value="Key")
        String key;
        @Label(value="Value")
        String value;

        ReportEntryEvent() {
        }
    }

    @Label(value="Test")
    @Name(value="org.junit.TestExecution")
    static class TestExecutionEvent
    extends TestEvent {
        @Label(value="Result")
        String result;
        @Label(value="Exception Class")
        Class<?> exceptionClass;
        @Label(value="Exception Message")
        String exceptionMessage;

        TestExecutionEvent() {
        }
    }

    @Label(value="Skipped Test")
    @Name(value="org.junit.SkippedTest")
    static class SkippedTestEvent
    extends TestEvent {
        @Label(value="Reason")
        String reason;

        SkippedTestEvent() {
        }
    }

    @Category(value={"JUnit"})
    @StackTrace(value=false)
    static abstract class TestEvent
    extends Event {
        @UniqueId
        @Label(value="Unique Id")
        String uniqueId;
        @Label(value="Display Name")
        String displayName;
        @Label(value="Tags")
        String tags;
        @Label(value="Type")
        String type;

        TestEvent() {
        }

        void initialize(TestIdentifier test) {
            this.uniqueId = test.getUniqueId();
            this.displayName = test.getDisplayName();
            this.tags = test.getTags().isEmpty() ? null : test.getTags().toString();
            this.type = test.getType().name();
        }
    }

    @MetadataDefinition
    @Relational
    @Name(value="org.junit.UniqueId")
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface UniqueId {
    }

    @Category(value={"JUnit"})
    @Label(value="Test Plan")
    @Name(value="org.junit.TestPlan")
    @StackTrace(value=false)
    static class TestPlanExecutionEvent
    extends Event {
        @Label(value="Contains Tests")
        boolean containsTests;
        @Label(value="Engine Names")
        String engineNames;

        TestPlanExecutionEvent() {
        }
    }
}

