/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public final class PackageUtils {
    static final String DEFAULT_PACKAGE_NAME = "";
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");

    private PackageUtils() {
    }

    public static void assertPackageNameIsValid(String packageName) {
        Preconditions.notNull(packageName, "package name must not be null");
        if (packageName.equals(DEFAULT_PACKAGE_NAME)) {
            return;
        }
        Preconditions.notBlank(packageName, "package name must not contain only whitespace");
        boolean allValid = Arrays.stream(DOT_PATTERN.split(packageName, -1)).allMatch(SourceVersion::isName);
        Preconditions.condition(allValid, "invalid part(s) in package name: " + packageName);
    }

    public static Optional<String> getAttribute(Class<?> type, Function<Package, String> function) {
        Preconditions.notNull(type, "type must not be null");
        Preconditions.notNull(function, "function must not be null");
        Package typePackage = type.getPackage();
        if (typePackage != null) {
            return Optional.ofNullable(function.apply(typePackage));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> getAttribute(Class<?> type, String name) {
        Preconditions.notNull(type, "type must not be null");
        Preconditions.notBlank(name, "name must not be blank");
        try {
            CodeSource codeSource = type.getProtectionDomain().getCodeSource();
            URL jarUrl = codeSource.getLocation();
            try (JarFile jarFile = new JarFile(new File(jarUrl.toURI()));){
                Manifest manifest = jarFile.getManifest();
                Attributes mainAttributes = manifest.getMainAttributes();
                Optional<String> optional = Optional.ofNullable(mainAttributes.getValue(name));
                return optional;
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

