/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.net.URL;
import java.security.CodeSource;
import java.util.Optional;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static ClassLoader getDefaultClassLoader() {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ClassLoader.getSystemClassLoader();
    }

    public static Optional<URL> getLocation(Object object) {
        Preconditions.notNull(object, "object must not be null");
        ClassLoader loader = object.getClass().getClassLoader();
        if (loader == null) {
            for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
            }
        }
        if (loader != null) {
            String name = object.getClass().getName();
            name = name.replace(".", "/") + ".class";
            try {
                return Optional.ofNullable(loader.getResource(name));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            CodeSource codeSource = object.getClass().getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                return Optional.ofNullable(codeSource.getLocation());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

