/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.engine.discovery.AbstractAnnotatedElementDescriptor;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestDescriptor;

class AbstractOrderingVisitor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOrderingVisitor.class);

    AbstractOrderingVisitor() {
    }

    protected <T extends TestDescriptor> void doWithMatchingDescriptor(Class<T> descriptorSubType, TestDescriptor testDescriptor, Consumer<T> action, Function<T, String> errorMessageBuilder) {
        if (descriptorSubType.isAssignableFrom(testDescriptor.getClass())) {
            TestDescriptor specificTestDescriptor = testDescriptor;
            try {
                action.accept(specificTestDescriptor);
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
                logger.error(t, () -> (String)errorMessageBuilder.apply(specificTestDescriptor));
            }
        }
    }

    protected <T extends TestDescriptor, D extends AbstractAnnotatedElementDescriptor<?>> void orderChildrenTestDescriptors(TestDescriptor parentTestDescriptor, Class<T> matchingChildrenType, Function<T, D> descriptorWrapperBuilder, Consumer<List<D>> orderingAction, IntFunction<String> descriptorsAddedLogger, IntFunction<String> descriptorsRemovedLogger) {
        Set children = parentTestDescriptor.getChildren();
        List nonMatchingTestDescriptors = children.stream().filter(childTestDescriptor -> !matchingChildrenType.isAssignableFrom(childTestDescriptor.getClass())).collect(Collectors.toList());
        List matchingDescriptorWrappers = children.stream().filter(matchingChildrenType::isInstance).map(matchingChildrenType::cast).map(descriptorWrapperBuilder).collect(Collectors.toCollection(ArrayList::new));
        LinkedHashSet originalDescriptors = new LinkedHashSet(matchingDescriptorWrappers);
        orderingAction.accept(matchingDescriptorWrappers);
        int difference = matchingDescriptorWrappers.size() - originalDescriptors.size();
        if (difference > 0) {
            logger.warn(() -> (String)descriptorsAddedLogger.apply(difference));
        } else if (difference < 0) {
            logger.warn(() -> (String)descriptorsRemovedLogger.apply(difference));
        }
        Set sortedTestDescriptors = matchingDescriptorWrappers.stream().filter(originalDescriptors::contains).map(AbstractAnnotatedElementDescriptor::getTestDescriptor).collect(Collectors.toCollection(LinkedHashSet::new));
        Stream.concat(sortedTestDescriptors.stream(), nonMatchingTestDescriptors.stream()).forEach(arg_0 -> ((TestDescriptor)parentTestDescriptor).removeChild(arg_0));
        Stream.concat(sortedTestDescriptors.stream(), nonMatchingTestDescriptors.stream()).forEach(arg_0 -> ((TestDescriptor)parentTestDescriptor).addChild(arg_0));
    }
}

