/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class ClassTestDescriptor
extends ClassBasedTestDescriptor {
    public static final String SEGMENT_TYPE = "class";

    public ClassTestDescriptor(UniqueId uniqueId, Class<?> testClass, JupiterConfiguration configuration) {
        super(uniqueId, testClass, DisplayNameUtils.createDisplayNameSupplierForClass(testClass, configuration), configuration);
    }

    public Set<TestTag> getTags() {
        return new LinkedHashSet<TestTag>(this.tags);
    }

    @Override
    public Node.ExecutionMode getExecutionMode() {
        return this.getExplicitExecutionMode().orElseGet(() -> JupiterTestDescriptor.toExecutionMode(this.configuration.getDefaultClassesExecutionMode()));
    }

    @Override
    protected TestInstances instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ExtensionContext extensionContext) {
        return this.instantiateTestClass(Optional.empty(), registry, extensionContext);
    }
}

