/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.INTERNAL, since="5.0")
public class NestedClassTestDescriptor
extends ClassTestDescriptor {
    public static final String SEGMENT_TYPE = "nested-class";
    private final Set<TestTag> tags;

    public NestedClassTestDescriptor(UniqueId uniqueId, Class<?> testClass, JupiterConfiguration configuration) {
        super(uniqueId, testClass, DisplayNameUtils.createDisplayNameSupplierForNestedClass(testClass), configuration);
        this.tags = NestedClassTestDescriptor.getTags(testClass);
    }

    @Override
    public final Set<TestTag> getTags() {
        LinkedHashSet<TestTag> allTags = new LinkedHashSet<TestTag>(this.tags);
        this.getParent().ifPresent(parentDescriptor -> allTags.addAll(parentDescriptor.getTags()));
        return allTags;
    }

    @Override
    protected TestInstances instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ExtensionContext extensionContext) {
        Optional<ExtensionRegistry> childExtensionRegistryForOuterInstance = Optional.empty();
        TestInstances outerInstances = parentExecutionContext.getTestInstancesProvider().getTestInstances(childExtensionRegistryForOuterInstance);
        return this.instantiateTestClass(Optional.of(outerInstances), registry, extensionContext);
    }
}

