/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.MethodTestDescriptor;
import org.junit.jupiter.engine.execution.ThrowableCollector;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.EngineExecutionListener;

@API(value=API.Usage.Internal)
public final class MethodBasedTestExtensionContext
extends AbstractExtensionContext<MethodTestDescriptor>
implements TestExtensionContext {
    private final Object testInstance;
    private final ThrowableCollector throwableCollector;

    public MethodBasedTestExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, MethodTestDescriptor testDescriptor, Object testInstance, ThrowableCollector throwableCollector) {
        super(parent, engineExecutionListener, testDescriptor);
        this.testInstance = testInstance;
        this.throwableCollector = throwableCollector;
    }

    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((MethodTestDescriptor)((Object)this.getTestDescriptor())).getTestMethod());
    }

    public Optional<Class<?>> getTestClass() {
        return Optional.of(((MethodTestDescriptor)((Object)this.getTestDescriptor())).getTestClass());
    }

    public Optional<Method> getTestMethod() {
        return Optional.of(((MethodTestDescriptor)((Object)this.getTestDescriptor())).getTestMethod());
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public Optional<Throwable> getTestException() {
        return Optional.ofNullable(this.throwableCollector.getThrowable());
    }
}

