/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

final class LifecycleMethodUtils {
    private LifecycleMethodUtils() {
    }

    static List<Method> findBeforeAllMethods(Class<?> testClass) {
        List methods = AnnotationUtils.findAnnotatedMethods(testClass, BeforeAll.class, (ReflectionUtils.MethodSortOrder)ReflectionUtils.MethodSortOrder.HierarchyDown);
        methods.forEach(method -> LifecycleMethodUtils.assertStatic(BeforeAll.class, method));
        return methods;
    }

    static List<Method> findAfterAllMethods(Class<?> testClass) {
        List methods = AnnotationUtils.findAnnotatedMethods(testClass, AfterAll.class, (ReflectionUtils.MethodSortOrder)ReflectionUtils.MethodSortOrder.HierarchyUp);
        methods.forEach(method -> LifecycleMethodUtils.assertStatic(AfterAll.class, method));
        return methods;
    }

    static List<Method> findBeforeEachMethods(Class<?> testClass) {
        List methods = AnnotationUtils.findAnnotatedMethods(testClass, BeforeEach.class, (ReflectionUtils.MethodSortOrder)ReflectionUtils.MethodSortOrder.HierarchyDown);
        methods.forEach(method -> LifecycleMethodUtils.assertNonStatic(BeforeEach.class, method));
        return methods;
    }

    static List<Method> findAfterEachMethods(Class<?> testClass) {
        List methods = AnnotationUtils.findAnnotatedMethods(testClass, AfterEach.class, (ReflectionUtils.MethodSortOrder)ReflectionUtils.MethodSortOrder.HierarchyUp);
        methods.forEach(method -> LifecycleMethodUtils.assertNonStatic(AfterEach.class, method));
        return methods;
    }

    private static void assertStatic(Class<? extends Annotation> annotationType, Method method) {
        if (!ReflectionUtils.isStatic((Member)method)) {
            throw new JUnitException(String.format("@%s method '%s' must be static.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertNonStatic(Class<? extends Annotation> annotationType, Method method) {
        if (ReflectionUtils.isStatic((Member)method)) {
            throw new JUnitException(String.format("@%s method '%s' must not be static.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }
}

