/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Executable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.engine.descriptor.DynamicTestTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodTestDescriptor;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.SingleTestExecutor;

@API(value=API.Usage.Internal)
public class TestFactoryTestDescriptor
extends MethodTestDescriptor {
    public static final String DYNAMIC_TEST_SEGMENT_TYPE = "dynamic-test";
    private static final SingleTestExecutor singleTestExecutor = new SingleTestExecutor();
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();

    public TestFactoryTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod) {
        super(uniqueId, testClass, testMethod);
    }

    @Override
    public boolean isTest() {
        return false;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public boolean hasTests() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    protected void invokeTestMethod(JupiterEngineExecutionContext context) {
        TestExtensionContext testExtensionContext = (TestExtensionContext)context.getExtensionContext();
        EngineExecutionListener listener = context.getExecutionListener();
        context.getThrowableCollector().execute(() -> {
            Method method = (Method)testExtensionContext.getTestMethod().get();
            Object instance = testExtensionContext.getTestInstance();
            Object testFactoryMethodResult = executableInvoker.invoke(method, instance, (ExtensionContext)testExtensionContext, context.getExtensionRegistry());
            try {
                AtomicInteger index = new AtomicInteger();
                this.toDynamicTestStream(testExtensionContext, testFactoryMethodResult).forEach(dynamicTest -> this.registerAndExecute((DynamicTest)dynamicTest, index.incrementAndGet(), listener));
            }
            catch (ClassCastException ex) {
                throw this.invalidReturnTypeException(testExtensionContext);
            }
        });
    }

    private Stream<DynamicTest> toDynamicTestStream(TestExtensionContext testExtensionContext, Object testFactoryMethodResult) {
        if (testFactoryMethodResult instanceof Stream) {
            return (Stream)testFactoryMethodResult;
        }
        if (testFactoryMethodResult instanceof Collection) {
            Collection collection = (Collection)testFactoryMethodResult;
            return collection.stream();
        }
        if (testFactoryMethodResult instanceof Iterable) {
            Iterable iterable = (Iterable)testFactoryMethodResult;
            return StreamSupport.stream(iterable.spliterator(), false);
        }
        if (testFactoryMethodResult instanceof Iterator) {
            Iterator iterator = (Iterator)testFactoryMethodResult;
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        }
        throw this.invalidReturnTypeException(testExtensionContext);
    }

    private void registerAndExecute(DynamicTest dynamicTest, int index, EngineExecutionListener listener) {
        UniqueId uniqueId = this.getUniqueId().append(DYNAMIC_TEST_SEGMENT_TYPE, "#" + index);
        DynamicTestTestDescriptor descriptor = new DynamicTestTestDescriptor(uniqueId, dynamicTest, (TestSource)this.getSource().get());
        this.addChild((TestDescriptor)descriptor);
        listener.dynamicTestRegistered((TestDescriptor)descriptor);
        listener.executionStarted((TestDescriptor)descriptor);
        TestExecutionResult result = singleTestExecutor.executeSafely(() -> ((Executable)dynamicTest.getExecutable()).execute());
        listener.executionFinished((TestDescriptor)descriptor, result);
    }

    private JUnitException invalidReturnTypeException(TestExtensionContext testExtensionContext) {
        return new JUnitException(String.format("@TestFactory method [%s] must return a Stream, Collection, Iterable, or Iterator of %s.", ((Method)testExtensionContext.getTestMethod().get()).toGenericString(), DynamicTest.class.getName()));
    }
}

