/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.support.hierarchical;

import java.util.Optional;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.support.hierarchical.EngineExecutionContext;

@API(value=API.Usage.Experimental)
public interface Node<C extends EngineExecutionContext> {
    default public C prepare(C context) throws Exception {
        return context;
    }

    default public SkipResult shouldBeSkipped(C context) throws Exception {
        return SkipResult.dontSkip();
    }

    public static class SkipResult {
        private final boolean skipped;
        private final String reason;

        public static SkipResult skip(String reason) {
            return new SkipResult(true, reason);
        }

        public static SkipResult dontSkip() {
            return new SkipResult(false, null);
        }

        private SkipResult(boolean skipped, String reason) {
            this.skipped = skipped;
            this.reason = reason;
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public Optional<String> getReason() {
            return Optional.ofNullable(this.reason);
        }
    }
}

