/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.support.descriptor;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.engine.TestSource;

@API(value=API.Usage.Experimental)
public class FileSystemSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final File sourceFileOrDirectory;
    private final FilePosition positionInFile;

    public FileSystemSource(File sourceFileOrDirectory) {
        this(sourceFileOrDirectory, null);
    }

    public FileSystemSource(File sourceFileOrDirectory, FilePosition positionInFile) {
        this.sourceFileOrDirectory = (File)Preconditions.notNull((Object)sourceFileOrDirectory, (String)"source file or directory must not be null");
        this.positionInFile = positionInFile;
    }

    @Override
    public boolean isJavaClass() {
        return false;
    }

    @Override
    public boolean isJavaMethod() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return !this.getPosition().isPresent() && this.sourceFileOrDirectory.isDirectory();
    }

    @Override
    public boolean isFile() {
        return !this.getPosition().isPresent() && this.sourceFileOrDirectory.isFile();
    }

    @Override
    public boolean isFilePosition() {
        return this.getPosition().isPresent();
    }

    public File getFile() {
        return this.sourceFileOrDirectory;
    }

    public Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.positionInFile);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.sourceFileOrDirectory.getAbsolutePath());
        this.getPosition().ifPresent(position -> {
            builder.append(" [");
            builder.append(position.getLine());
            builder.append(':');
            builder.append(position.getColumn());
            builder.append(']');
        });
        return builder.toString();
    }

    public static class FilePosition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int line;
        private final int column;

        public FilePosition(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

