/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.support.descriptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.gen5.commons.JUnitException;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestSource;
import org.junit.gen5.engine.TestTag;

@API(value=API.Usage.Experimental)
public abstract class AbstractTestDescriptor
implements TestDescriptor {
    private final String uniqueId;
    private TestDescriptor parent;
    private TestSource source;
    private final Set<TestDescriptor> children = new LinkedHashSet<TestDescriptor>();

    protected AbstractTestDescriptor(String uniqueId) {
        this.uniqueId = Preconditions.notBlank((String)uniqueId, (String)"uniqueId must not be null or empty");
    }

    @Override
    public final String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Optional<TestDescriptor> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public final void setParent(TestDescriptor parent) {
        this.parent = parent;
    }

    @Override
    public void removeChild(TestDescriptor child) {
        this.children.remove(child);
        child.setParent(null);
    }

    protected void removeFromHierarchy() {
        if (this.isRoot()) {
            throw new JUnitException("You cannot remove the root of a hierarchy.");
        }
        this.parent.removeChild(this);
        this.children.clear();
    }

    @Override
    public Optional<? extends TestDescriptor> findByUniqueId(String uniqueId) {
        if (this.getUniqueId().equals(uniqueId)) {
            return Optional.of(this);
        }
        for (TestDescriptor child : this.children) {
            Optional<? extends TestDescriptor> result = child.findByUniqueId(uniqueId);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public void addChild(TestDescriptor child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        child.setParent(this);
        this.children.add(child);
    }

    @Override
    public Set<? extends TestDescriptor> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    protected final void setSource(TestSource source) {
        this.source = (TestSource)Preconditions.notNull((Object)source, (String)"TestSource must not be null");
    }

    @Override
    public void accept(TestDescriptor.Visitor visitor) {
        Runnable remove = this::removeFromHierarchy;
        visitor.visit(this, remove);
        new LinkedHashSet<TestDescriptor>(this.getChildren()).forEach(child -> child.accept(visitor));
    }

    @Override
    public Set<TestTag> getTags() {
        return Collections.emptySet();
    }

    @Override
    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TestDescriptor otherDescriptor = (TestDescriptor)other;
        return this.getUniqueId().equals(otherDescriptor.getUniqueId());
    }

    public final int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getUniqueId();
    }
}

