/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.value.convert.number;

import java.math.BigDecimal;
import org.jtwig.value.Undefined;
import org.jtwig.value.convert.Converter;

public class BigDecimalConverter
implements Converter<BigDecimal> {
    @Override
    public Converter.Result<BigDecimal> convert(Object object) {
        if (object == null) {
            return Converter.Result.defined(BigDecimal.ZERO);
        }
        if (object == Undefined.UNDEFINED) {
            return Converter.Result.defined(BigDecimal.ZERO);
        }
        if (object instanceof BigDecimal) {
            return Converter.Result.defined((BigDecimal)object);
        }
        if (object instanceof Number) {
            return Converter.Result.defined(new BigDecimal(((Number)object).doubleValue()));
        }
        if (object instanceof Boolean) {
            return Converter.Result.defined((Boolean)object != false ? BigDecimal.ONE : BigDecimal.ZERO);
        }
        try {
            if (object instanceof String) {
                return Converter.Result.defined(new BigDecimal((String)object));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Converter.Result.undefined();
    }
}

