/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.strategy;

import com.google.common.base.Optional;
import org.jtwig.model.expression.VariableExpression;
import org.jtwig.property.resolver.CallMethodPropertyResolver;
import org.jtwig.property.resolver.PropertyResolver;
import org.jtwig.property.strategy.PropertyResolverStrategy;
import org.jtwig.reflection.model.java.JavaClass;
import org.jtwig.reflection.model.java.JavaClassManager;
import org.jtwig.reflection.model.java.JavaMethod;
import org.jtwig.reflection.model.java.JavaMethods;

public class GetMethodPropertyResolverStrategy
implements PropertyResolverStrategy {
    private final JavaClassManager classManager;

    public GetMethodPropertyResolverStrategy(JavaClassManager classManager) {
        this.classManager = classManager;
    }

    @Override
    public Optional<PropertyResolver> select(PropertyResolverStrategy.Request request) {
        if (request.getRightExpression() instanceof VariableExpression) {
            String identifier = ((VariableExpression)request.getRightExpression()).getIdentifier();
            JavaClass javaClass = this.classManager.metadata(request.getLeftValue().getClass());
            JavaMethods method = javaClass.method("get");
            Optional methodMethod = method.getMethod(new Class[]{String.class});
            if (methodMethod.isPresent()) {
                CallMethodPropertyResolver callMethodPropertyResolver = new CallMethodPropertyResolver((JavaMethod)methodMethod.get(), identifier);
                return Optional.of((Object)callMethodPropertyResolver);
            }
        }
        return Optional.absent();
    }
}

