/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.cli;

import com.beust.jcommander.IParameterValidator2;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jsonschema2pojo.AbstractRuleLogger;

public class CommandLineLogger
extends AbstractRuleLogger {
    public static final String DEFAULT_LOG_LEVEL = LogLevel.INFO.value();
    private final int logLevel;

    public CommandLineLogger(String logLevel) {
        this.logLevel = LogLevel.fromValue(logLevel).levelInt();
    }

    public boolean isDebugEnabled() {
        return this.logLevel >= LogLevel.DEBUG.levelInt();
    }

    public boolean isErrorEnabled() {
        return this.logLevel >= LogLevel.ERROR.levelInt();
    }

    public boolean isInfoEnabled() {
        return this.logLevel >= LogLevel.INFO.levelInt();
    }

    public boolean isTraceEnabled() {
        return this.logLevel >= LogLevel.TRACE.levelInt();
    }

    public boolean isWarnEnabled() {
        return this.logLevel >= LogLevel.WARN.levelInt();
    }

    public void printLogLevels() {
        Set<String> levelNames = LogLevel.getLevelNames();
        String levelNamesJoined = levelNames.stream().collect(Collectors.joining(", "));
        System.out.println("Available Log Levels: " + levelNamesJoined);
    }

    protected void doDebug(String msg) {
        System.out.println(msg);
    }

    protected void doError(String msg, Throwable e) {
        System.err.println(msg);
        if (e != null) {
            e.printStackTrace(System.err);
        }
    }

    protected void doInfo(String msg) {
        System.out.print(msg);
    }

    protected void doTrace(String msg) {
        System.out.print(msg);
    }

    protected void doWarn(String msg, Throwable e) {
        System.err.println(msg);
        if (e != null) {
            e.printStackTrace(System.err);
        }
    }

    public static class LogLevelValidator
    implements IParameterValidator2 {
        public void validate(String name, String value, ParameterDescription pd) throws ParameterException {
            Set<String> availableLogLevels = LogLevel.getLevelNames();
            if (!availableLogLevels.contains(value)) {
                String availableLevelJoined = availableLogLevels.stream().collect(Collectors.joining(", ", "[", "]"));
                throw new ParameterException("The parameter " + name + " must be one of " + availableLevelJoined);
            }
        }

        public void validate(String name, String value) throws ParameterException {
            this.validate(name, value, null);
        }
    }

    public static enum LogLevel {
        OFF("off", -2),
        ERROR("error", -1),
        WARN("warn", 0),
        INFO("info", 1),
        DEBUG("debug", 2),
        TRACE("trace", 3);

        private static final Map<String, LogLevel> LEVEL_NAMES;
        private final String levelName;
        private final int levelInt;

        private LogLevel(String value, int levelInt) {
            this.levelName = value;
            this.levelInt = levelInt;
        }

        @JsonCreator
        public static LogLevel fromValue(String value) {
            LogLevel constant = LEVEL_NAMES.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public static Set<String> getLevelNames() {
            return LEVEL_NAMES.keySet();
        }

        public int levelInt() {
            return this.levelInt;
        }

        public String toString() {
            return this.levelName;
        }

        @JsonValue
        public String value() {
            return this.levelName;
        }

        static {
            LEVEL_NAMES = new LinkedHashMap<String, LogLevel>();
            for (LogLevel c : LogLevel.values()) {
                LEVEL_NAMES.put(c.levelName, c);
            }
        }
    }
}

