/*
 * Decompiled with CFR 0.152.
 */
package org.json4s;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.json4s.ParserUtil$;
import org.json4s.Segment;
import org.json4s.Segments;
import org.json4s.Segments$DisposableSegment$;
import org.json4s.Segments$RecycledSegment$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;

public final class Segments$
implements Serializable {
    private static final boolean enableSegments;
    private static int segmentSize;
    private static final int maxNumOfSegments;
    private static final AtomicInteger segmentCount;
    private static final ArrayBlockingQueue<Segment> segments;
    private static final Segments$RecycledSegment$ RecycledSegment;
    private static final Segments$DisposableSegment$ DisposableSegment;
    public static final Segments$ MODULE$;

    private Segments$() {
    }

    static {
        MODULE$ = new Segments$();
        Option option = package$.MODULE$.props().get("json4s.segments.enable");
        Some some = Some$.MODULE$.apply((Object)"false");
        enableSegments = option == null ? some != null : !option.equals(some);
        segmentSize = ParserUtil$.MODULE$.defaultSegmentSize();
        maxNumOfSegments = 10000;
        segmentCount = new AtomicInteger(0);
        segments = new ArrayBlockingQueue(maxNumOfSegments);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Segments$.class);
    }

    public int segmentSize() {
        return segmentSize;
    }

    public void segmentSize_$eq(int x$1) {
        segmentSize = x$1;
    }

    public void clear() {
        segments.clear();
    }

    public Segment apply() {
        if (enableSegments) {
            Segment s = this.acquire();
            if (s != null) {
                return s;
            }
            return Segments$DisposableSegment$.MODULE$.apply(new char[this.segmentSize()]);
        }
        return Segments$DisposableSegment$.MODULE$.apply(new char[this.segmentSize()]);
    }

    private Segment acquire() {
        boolean createNew;
        int curCount = segmentCount.get();
        boolean bl = createNew = segments.size() == 0 && curCount < maxNumOfSegments ? segmentCount.compareAndSet(curCount, curCount + 1) : false;
        if (createNew) {
            return Segments$RecycledSegment$.MODULE$.apply(new char[this.segmentSize()]);
        }
        return segments.poll();
    }

    public void release(Segment s) {
        Segment segment = s;
        if (segment instanceof Segments.RecycledSegment) {
            segments.offer(s);
            return;
        }
    }
}

