/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.util;

import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DSymbolNode;
import org.jrubyparser.ast.ILocalScope;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.INameMatchable;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.ZSuperNode;

public class VariableHelper {
    public static boolean isParameterUsed(Node node, String name, boolean isMethod) {
        for (Node child : node.childNodes()) {
            if (child instanceof INameMatchable && child instanceof ILocalVariable && ((INameMatchable)((Object)child)).isNameMatch(name)) {
                if (!(child instanceof DAsgnNode) && !(child instanceof LocalAsgnNode)) {
                    return true;
                }
            } else {
                if (child instanceof ZSuperNode) {
                    return true;
                }
                if (child instanceof AliasNode) {
                    boolean match = ((AliasNode)child).oldNameMatches(name);
                    if (match) {
                        return match;
                    }
                    if (((AliasNode)child).getOldName() instanceof DSymbolNode && VariableHelper.isParameterUsed(((AliasNode)child).getOldName(), name, isMethod)) {
                        return true;
                    }
                    if (((AliasNode)child).getNewName() instanceof DSymbolNode && VariableHelper.isParameterUsed(((AliasNode)child).getNewName(), name, isMethod)) {
                        return true;
                    }
                }
            }
            if (!VariableHelper.isParameterUsed(child, name, isMethod)) continue;
            return true;
        }
        return false;
    }

    public static Node getParameterName(Node argsNode, String name) {
        return VariableHelper.getParameterNameInner(argsNode, name);
    }

    private static Node getParameterNameInner(Node node, String name) {
        for (Node child : node.childNodes()) {
            if (child instanceof ILocalScope) {
                return null;
            }
            if (child instanceof ILocalVariable && ((INameMatchable)((Object)child)).isNameMatch(name)) {
                return child;
            }
            Node result = VariableHelper.getParameterName(child, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

