/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseNode
extends Node {
    private Node caseNode;
    private ListNode cases;
    private Node elseNode = null;

    public CaseNode(SourcePosition position, Node caseNode, ListNode cases) {
        super(position);
        assert (cases != null) : "caseBody is not null";
        this.caseNode = this.adopt(caseNode);
        this.cases = (ListNode)this.adopt(cases);
    }

    public void setElseNode(Node elseNode) {
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CASENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitCaseNode(this);
    }

    public Node getCase() {
        return this.caseNode;
    }

    @Deprecated
    public Node getCaseNode() {
        return this.getCase();
    }

    public ListNode getCases() {
        return this.cases;
    }

    public Node getElse() {
        return this.elseNode;
    }

    @Deprecated
    public Node getElseNode() {
        return this.getElse();
    }

    public Node getFirstWhen() {
        return this.cases;
    }

    @Deprecated
    public Node getFirstWhenNode() {
        return this.getFirstWhen();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.caseNode, this.cases);
    }
}

