/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.BlockAcceptingNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node argsNode;
    protected Node iterNode;
    protected String name;
    private boolean hasParens = false;

    public FCallNode(SourcePosition position, String name, Node argsNode) {
        this(position, name, argsNode, null);
    }

    public FCallNode(SourcePosition position, String name, Node argsNode, Node iterNode) {
        super(position);
        this.argsNode = this.adopt(argsNode);
        this.iterNode = this.adopt(iterNode);
        this.name = name;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FCALLNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public boolean hasParens() {
        return this.hasParens;
    }

    @Override
    public void setHasParens(boolean hasParens) {
        this.hasParens = hasParens;
    }

    @Deprecated
    public Node getIterNode() {
        return this.getIter();
    }

    @Override
    public Node getIter() {
        return this.iterNode;
    }

    public Node setIterNode(Node iterNode) {
        this.iterNode = this.adopt(iterNode);
        return this;
    }

    @Override
    public void setIter(Node iter) {
        this.iterNode = this.adopt(iter);
    }

    @Deprecated
    public Node getArgsNode() {
        return this.getArgs();
    }

    @Override
    public Node getArgs() {
        return this.argsNode;
    }

    @Deprecated
    public Node setArgsNode(Node argsNode) {
        this.setArgs(argsNode);
        return argsNode;
    }

    @Override
    public void setArgs(Node argsNode) {
        this.argsNode = this.adopt(argsNode);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }
}

