/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.posix;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.platform.FDSet;

public class PosixFDSet8Bytes
implements FDSet {
    private static final int MAX_FDS = 1024;
    private static final int FIELD_SIZE_IN_BYTES = 8;
    private static final int FIELD_SIZE_IN_BITS = 64;
    private final Pointer bitmap = Runtime.getSystemRuntime().getMemoryManager().allocateDirect(128);

    @Override
    public void set(int fd) {
        this.checkBounds(fd);
        int offset = this.bitmapAddressOffset(fd);
        this.bitmap.putLong((long)offset, this.bitmap.getLong((long)offset) | this.bitmapElementMask(fd));
    }

    @Override
    public boolean isSet(int fd) {
        this.checkBounds(fd);
        return (this.bitmap.getLong((long)this.bitmapAddressOffset(fd)) & this.bitmapElementMask(fd)) != 0L;
    }

    @Override
    public Pointer getPointer() {
        return this.bitmap;
    }

    private void checkBounds(int fd) {
        if (fd < 0 || fd >= 1024) {
            throw new IllegalArgumentException(StringUtils.format("Supplied file descriptor value must be > 0 and < %d", 1024));
        }
    }

    private int bitmapElementIndex(int fd) {
        return fd / 64;
    }

    private int bitmapAddressOffset(int fd) {
        return this.bitmapElementIndex(fd) * 8;
    }

    private long bitmapElementMask(int fd) {
        return 1L << fd % 64;
    }
}

