/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.LoadRequiredLibrariesNode;
import org.jruby.truffle.language.DataNode;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.exceptions.TopLevelRaiseHandler;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.CatchNextNode;
import org.jruby.truffle.language.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.language.methods.CatchReturnAsErrorNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.parser.BodyTranslator;
import org.jruby.truffle.parser.ParseEnvironment;
import org.jruby.truffle.parser.ParserContext;
import org.jruby.truffle.parser.RubyWarnings;
import org.jruby.truffle.parser.Translator;
import org.jruby.truffle.parser.TranslatorEnvironment;
import org.jruby.truffle.parser.ast.RootParseNode;
import org.jruby.truffle.parser.lexer.LexerSource;
import org.jruby.truffle.parser.lexer.SyntaxException;
import org.jruby.truffle.parser.parser.ParserConfiguration;
import org.jruby.truffle.parser.parser.RubyParser;
import org.jruby.truffle.parser.parser.RubyParserResult;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;

public class TranslatorDriver {
    private final RubyContext context;
    private final ParseEnvironment parseEnvironment;

    public TranslatorDriver(RubyContext context) {
        this.context = context;
        this.parseEnvironment = new ParseEnvironment(context);
    }

    public RubyRootNode parse(RubyContext context, Source source, Encoding defaultEncoding, ParserContext parserContext, String[] argumentNames, FrameDescriptor frameDescriptor, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode) {
        boolean topLevel;
        TranslatorEnvironment parentEnvironment;
        StaticScope staticScope = new StaticScope(StaticScope.Type.LOCAL, null);
        if (frameDescriptor != null) {
            for (Object slot : frameDescriptor.getSlots()) {
                if (!(slot.getIdentifier() instanceof String)) continue;
                String name = (String)slot.getIdentifier();
                staticScope.addVariableThisScope(name.intern());
            }
            parentEnvironment = this.environmentForFrameDescriptor(context, frameDescriptor);
        } else if (parentFrame != null) {
            MaterializedFrame frame = parentFrame;
            while (frame != null) {
                for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
                    if (!(slot.getIdentifier() instanceof String)) continue;
                    Object name = (String)slot.getIdentifier();
                    staticScope.addVariableThisScope(((String)name).intern());
                }
                frame = RubyArguments.getDeclarationFrame((Frame)frame);
            }
            parentEnvironment = this.environmentForFrame(context, parentFrame);
        } else {
            parentEnvironment = this.environmentForFrame(context, null);
        }
        if (argumentNames != null) {
            for (Object name : argumentNames) {
                staticScope.addVariableThisScope(((String)name).intern());
            }
        }
        DynamicScope dynamicScope = new DynamicScope(staticScope);
        boolean isInlineSource = parserContext == ParserContext.SHELL;
        boolean isEvalParse = parserContext == ParserContext.EVAL || parserContext == ParserContext.INLINE || parserContext == ParserContext.MODULE;
        ParserConfiguration parserConfiguration = new ParserConfiguration(context, 0, isInlineSource, !isEvalParse, false);
        if (context.getOptions().FROZEN_STRING_LITERALS) {
            parserConfiguration.setFrozenStringLiteral(true);
        }
        parserConfiguration.setDefaultEncoding(defaultEncoding);
        RootParseNode node = this.parse(source, dynamicScope, parserConfiguration);
        SourceSection sourceSection = source.createSection(0, source.getCode().length());
        SourceIndexLength sourceIndexLength = new SourceIndexLength(sourceSection.getCharIndex(), sourceSection.getCharLength());
        InternalMethod parentMethod = parentFrame == null ? null : RubyArguments.getMethod((Frame)parentFrame);
        LexicalScope lexicalScope = parentMethod != null && parentMethod.getSharedMethodInfo().getLexicalScope() != null ? parentMethod.getSharedMethodInfo().getLexicalScope() : context.getRootLexicalScope();
        if (parserContext == ParserContext.MODULE) {
            Object module = RubyArguments.getSelf(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
            lexicalScope = new LexicalScope(lexicalScope, (DynamicObject)module);
        }
        this.parseEnvironment.resetLexicalScope(lexicalScope);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.parseEnvironment.getLexicalScope(), Arity.NO_ARGUMENTS, null, "<main>", null, null, false, false, false);
        boolean isModuleBody = topLevel = parserContext == ParserContext.TOP_LEVEL_FIRST || parserContext == ParserContext.TOP_LEVEL;
        TranslatorEnvironment environment = new TranslatorEnvironment(context, parentEnvironment, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), ownScopeForAssignments, false, isModuleBody, sharedMethodInfo, sharedMethodInfo.getName(), 0, null);
        if (argumentNames != null) {
            for (MaterializedFrame name : argumentNames) {
                environment.declareVar((String)name);
            }
        }
        BodyTranslator translator = new BodyTranslator(currentNode, context, null, environment, source, topLevel);
        RubyNode truffleNode = translator.translateNodeOrNil(sourceIndexLength, node.getBodyNode());
        RubyNode writeSelfNode = Translator.loadSelf(context, environment);
        truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(writeSelfNode, truffleNode));
        if (argumentNames != null && ((MaterializedFrame)argumentNames).length > 0) {
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            for (int n = 0; n < ((MaterializedFrame)argumentNames).length; ++n) {
                MaterializedFrame name = argumentNames[n];
                ProfileArgumentNode readNode = new ProfileArgumentNode(new ReadPreArgumentNode(n, MissingArgumentBehavior.NIL));
                FrameSlot slot = environment.getFrameDescriptor().findFrameSlot((Object)name);
                sequence.add(WriteLocalVariableNode.createWriteLocalVariableNode(context, slot, readNode));
            }
            sequence.add(truffleNode);
            truffleNode = Translator.sequence(sourceIndexLength, sequence);
        }
        if (environment.getFlipFlopStates().size() > 0) {
            truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(translator.initFlipFlopStates(sourceIndexLength), truffleNode));
        }
        truffleNode = new CatchNextNode(truffleNode);
        if (parserContext != ParserContext.INLINE) {
            truffleNode = new CatchReturnAsErrorNode(truffleNode);
        }
        truffleNode = new CatchRetryAsErrorNode(truffleNode);
        if (parserContext == ParserContext.TOP_LEVEL_FIRST) {
            truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(new RubyNode[]{new LoadRequiredLibrariesNode(), truffleNode}));
            if (node.hasEndPosition()) {
                truffleNode = Translator.sequence(sourceIndexLength, Arrays.asList(new RubyNode[]{new DataNode(node.getEndPosition()), truffleNode}));
            }
            truffleNode = new ExceptionTranslatingNode(truffleNode, UnsupportedOperationBehavior.TYPE_ERROR);
            truffleNode = new TopLevelRaiseHandler(truffleNode);
        }
        return new RubyRootNode(context, sourceIndexLength.toSourceSection(source), environment.getFrameDescriptor(), sharedMethodInfo, truffleNode, environment.needsDeclarationFrame());
    }

    public RootParseNode parse(Source source, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyParserResult result;
        LexerSource ByteListLexerSource = new LexerSource(source, configuration.getLineNumber(), configuration.getDefaultEncoding());
        if (blockScope != null) {
            configuration.parseAsBlock(blockScope);
        }
        RubyParser parser = new RubyParser(this.context, ByteListLexerSource, new RubyWarnings(configuration.getContext()));
        try {
            result = parser.parse(configuration);
        }
        catch (IOException e) {
            throw new RaiseException(this.context.getCoreExceptions().syntaxError("Problem reading source: " + e, null));
        }
        catch (SyntaxException e) {
            switch (e.getPid()) {
                case UNKNOWN_ENCODING: 
                case NOT_ASCII_COMPATIBLE: {
                    throw new RaiseException(this.context.getCoreExceptions().argumentError(e.getMessage(), null));
                }
            }
            StringBuilder buffer = new StringBuilder(100);
            buffer.append(e.getFile()).append(':');
            buffer.append(e.getLine() + 1).append(": ");
            buffer.append(e.getMessage());
            throw new RaiseException(this.context.getCoreExceptions().syntaxError(buffer.toString(), null));
        }
        if (result.getScope() != null) {
            result.getScope().growIfNeeded();
        }
        return (RootParseNode)result.getAST();
    }

    private TranslatorEnvironment environmentForFrameDescriptor(RubyContext context, FrameDescriptor frameDescriptor) {
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(context.getCoreLibrary().getSourceSection(), context.getRootLexicalScope(), Arity.NO_ARGUMENTS, null, null, "external", null, false, false, false);
        return new TranslatorEnvironment(context, null, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, true, false, sharedMethodInfo, sharedMethodInfo.getName(), 0, null, frameDescriptor);
    }

    private TranslatorEnvironment environmentForFrame(RubyContext context, MaterializedFrame frame) {
        if (frame == null) {
            return null;
        }
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(context.getCoreLibrary().getSourceSection(), context.getRootLexicalScope(), Arity.NO_ARGUMENTS, null, null, "external", null, false, false, false);
        MaterializedFrame parent = RubyArguments.getDeclarationFrame((Frame)frame);
        return new TranslatorEnvironment(context, this.environmentForFrame(context, parent), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, true, false, sharedMethodInfo, sharedMethodInfo.getName(), 0, null, frame.getFrameDescriptor());
    }
}

