/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Syntax;
import org.jruby.truffle.Log;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.builtins.PrimitiveNodeConstructor;
import org.jruby.truffle.collections.Tuple;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.IsNilNode;
import org.jruby.truffle.core.IsRubiniusUndefinedNode;
import org.jruby.truffle.core.RaiseIfFrozenNode;
import org.jruby.truffle.core.array.ArrayAppendOneNode;
import org.jruby.truffle.core.array.ArrayAppendOneNodeGen;
import org.jruby.truffle.core.array.ArrayConcatNode;
import org.jruby.truffle.core.array.ArrayDropTailNode;
import org.jruby.truffle.core.array.ArrayDropTailNodeGen;
import org.jruby.truffle.core.array.ArrayGetTailNodeGen;
import org.jruby.truffle.core.array.ArrayLiteralNode;
import org.jruby.truffle.core.array.PrimitiveArrayNodeFactory;
import org.jruby.truffle.core.cast.HashCastNodeGen;
import org.jruby.truffle.core.cast.IntegerCastNodeGen;
import org.jruby.truffle.core.cast.SplatCastNode;
import org.jruby.truffle.core.cast.SplatCastNodeGen;
import org.jruby.truffle.core.cast.StringToSymbolNode;
import org.jruby.truffle.core.cast.StringToSymbolNodeGen;
import org.jruby.truffle.core.cast.ToProcNodeGen;
import org.jruby.truffle.core.cast.ToSNode;
import org.jruby.truffle.core.cast.ToSNodeGen;
import org.jruby.truffle.core.hash.ConcatHashLiteralNode;
import org.jruby.truffle.core.hash.EnsureSymbolKeysNode;
import org.jruby.truffle.core.hash.HashLiteralNode;
import org.jruby.truffle.core.hash.HashNodes;
import org.jruby.truffle.core.hash.HashNodesFactory;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.module.ModuleNodes;
import org.jruby.truffle.core.module.ModuleNodesFactory;
import org.jruby.truffle.core.numeric.BignumOperations;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.core.range.RangeNodes;
import org.jruby.truffle.core.range.RangeNodesFactory;
import org.jruby.truffle.core.regexp.InterpolatedRegexpNode;
import org.jruby.truffle.core.regexp.MatchDataNodes;
import org.jruby.truffle.core.regexp.MatchDataNodesFactory;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.core.regexp.RegexpOptions;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rubinius.RubiniusLastStringReadNode;
import org.jruby.truffle.core.rubinius.RubiniusLastStringWriteNodeGen;
import org.jruby.truffle.core.string.InterpolatedStringNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.language.Visibility;
import org.jruby.truffle.language.arguments.ArrayIsAtLeastAsLargeAsNode;
import org.jruby.truffle.language.arguments.SingleBlockArgNode;
import org.jruby.truffle.language.constants.ReadConstantNode;
import org.jruby.truffle.language.constants.ReadConstantWithDynamicScopeNode;
import org.jruby.truffle.language.constants.ReadConstantWithLexicalScopeNode;
import org.jruby.truffle.language.constants.WriteConstantNode;
import org.jruby.truffle.language.control.AndNode;
import org.jruby.truffle.language.control.BreakID;
import org.jruby.truffle.language.control.BreakNode;
import org.jruby.truffle.language.control.ElidableResultNode;
import org.jruby.truffle.language.control.FrameOnStackNode;
import org.jruby.truffle.language.control.IfElseNode;
import org.jruby.truffle.language.control.IfNode;
import org.jruby.truffle.language.control.NextNode;
import org.jruby.truffle.language.control.NotNode;
import org.jruby.truffle.language.control.OnceNode;
import org.jruby.truffle.language.control.OrNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.RedoNode;
import org.jruby.truffle.language.control.RetryNode;
import org.jruby.truffle.language.control.ReturnID;
import org.jruby.truffle.language.control.ReturnNode;
import org.jruby.truffle.language.control.UnlessNode;
import org.jruby.truffle.language.control.WhileNode;
import org.jruby.truffle.language.defined.DefinedNode;
import org.jruby.truffle.language.defined.DefinedWrapperNode;
import org.jruby.truffle.language.dispatch.RubyCallNode;
import org.jruby.truffle.language.dispatch.RubyCallNodeParameters;
import org.jruby.truffle.language.exceptions.DisablingBacktracesNode;
import org.jruby.truffle.language.exceptions.EnsureNode;
import org.jruby.truffle.language.exceptions.RescueAnyNode;
import org.jruby.truffle.language.exceptions.RescueClassesNode;
import org.jruby.truffle.language.exceptions.RescueNode;
import org.jruby.truffle.language.exceptions.RescueSplatNode;
import org.jruby.truffle.language.exceptions.TryNode;
import org.jruby.truffle.language.globals.AliasGlobalVarNode;
import org.jruby.truffle.language.globals.CheckMatchVariableTypeNode;
import org.jruby.truffle.language.globals.CheckOutputSeparatorVariableTypeNode;
import org.jruby.truffle.language.globals.CheckProgramNameVariableTypeNode;
import org.jruby.truffle.language.globals.CheckRecordSeparatorVariableTypeNode;
import org.jruby.truffle.language.globals.CheckStdoutVariableTypeNode;
import org.jruby.truffle.language.globals.ReadGlobalVariableNodeGen;
import org.jruby.truffle.language.globals.ReadLastBacktraceNode;
import org.jruby.truffle.language.globals.ReadMatchReferenceNode;
import org.jruby.truffle.language.globals.ReadThreadLocalGlobalVariableNode;
import org.jruby.truffle.language.globals.UpdateLastBacktraceNode;
import org.jruby.truffle.language.globals.UpdateVerbosityNode;
import org.jruby.truffle.language.globals.WriteGlobalVariableNode;
import org.jruby.truffle.language.globals.WriteGlobalVariableNodeGen;
import org.jruby.truffle.language.globals.WriteReadOnlyGlobalNode;
import org.jruby.truffle.language.literal.BooleanLiteralNode;
import org.jruby.truffle.language.literal.FloatLiteralNode;
import org.jruby.truffle.language.literal.IntegerFixnumLiteralNode;
import org.jruby.truffle.language.literal.LongFixnumLiteralNode;
import org.jruby.truffle.language.literal.NilLiteralNode;
import org.jruby.truffle.language.literal.ObjectLiteralNode;
import org.jruby.truffle.language.literal.StringLiteralNode;
import org.jruby.truffle.language.locals.DeclarationFlipFlopStateNode;
import org.jruby.truffle.language.locals.FlipFlopNode;
import org.jruby.truffle.language.locals.FlipFlopStateNode;
import org.jruby.truffle.language.locals.InitFlipFlopSlotNode;
import org.jruby.truffle.language.locals.LocalFlipFlopStateNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.methods.AddMethodNodeGen;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.BlockDefinitionNode;
import org.jruby.truffle.language.methods.CatchBreakNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.GetCurrentVisibilityNode;
import org.jruby.truffle.language.methods.GetDefaultDefineeNode;
import org.jruby.truffle.language.methods.MethodDefinitionNode;
import org.jruby.truffle.language.methods.ModuleBodyDefinitionNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.language.objects.DefineClassNode;
import org.jruby.truffle.language.objects.DefineModuleNode;
import org.jruby.truffle.language.objects.DefineModuleNodeGen;
import org.jruby.truffle.language.objects.DynamicLexicalScopeNode;
import org.jruby.truffle.language.objects.LexicalScopeNode;
import org.jruby.truffle.language.objects.ReadClassVariableNode;
import org.jruby.truffle.language.objects.ReadInstanceVariableNode;
import org.jruby.truffle.language.objects.RunModuleDefinitionNode;
import org.jruby.truffle.language.objects.SelfNode;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.objects.SingletonClassNodeGen;
import org.jruby.truffle.language.objects.WriteClassVariableNode;
import org.jruby.truffle.language.objects.WriteInstanceVariableNode;
import org.jruby.truffle.language.threadlocal.GetFromThreadLocalNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNodeGen;
import org.jruby.truffle.language.threadlocal.WrapInThreadLocalNodeGen;
import org.jruby.truffle.language.yield.YieldExpressionNode;
import org.jruby.truffle.parser.ArgumentDescriptor;
import org.jruby.truffle.parser.ConstantReplacer;
import org.jruby.truffle.parser.DeadNode;
import org.jruby.truffle.parser.Helpers;
import org.jruby.truffle.parser.MethodTranslator;
import org.jruby.truffle.parser.ParseEnvironment;
import org.jruby.truffle.parser.ParserByteList;
import org.jruby.truffle.parser.ReadLocalDummyParseNode;
import org.jruby.truffle.parser.ReadLocalNode;
import org.jruby.truffle.parser.Translator;
import org.jruby.truffle.parser.TranslatorEnvironment;
import org.jruby.truffle.parser.ast.AliasParseNode;
import org.jruby.truffle.parser.ast.AndParseNode;
import org.jruby.truffle.parser.ast.ArgsCatParseNode;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgsPushParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.ArrayParseNode;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.AttrAssignParseNode;
import org.jruby.truffle.parser.ast.BackRefParseNode;
import org.jruby.truffle.parser.ast.BeginParseNode;
import org.jruby.truffle.parser.ast.BignumParseNode;
import org.jruby.truffle.parser.ast.BlockParseNode;
import org.jruby.truffle.parser.ast.BlockPassParseNode;
import org.jruby.truffle.parser.ast.BreakParseNode;
import org.jruby.truffle.parser.ast.CallParseNode;
import org.jruby.truffle.parser.ast.CaseParseNode;
import org.jruby.truffle.parser.ast.ClassParseNode;
import org.jruby.truffle.parser.ast.ClassVarAsgnParseNode;
import org.jruby.truffle.parser.ast.ClassVarParseNode;
import org.jruby.truffle.parser.ast.Colon2ConstParseNode;
import org.jruby.truffle.parser.ast.Colon2ImplicitParseNode;
import org.jruby.truffle.parser.ast.Colon2ParseNode;
import org.jruby.truffle.parser.ast.Colon3ParseNode;
import org.jruby.truffle.parser.ast.ComplexParseNode;
import org.jruby.truffle.parser.ast.ConstDeclParseNode;
import org.jruby.truffle.parser.ast.ConstParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.DRegexpParseNode;
import org.jruby.truffle.parser.ast.DStrParseNode;
import org.jruby.truffle.parser.ast.DSymbolParseNode;
import org.jruby.truffle.parser.ast.DVarParseNode;
import org.jruby.truffle.parser.ast.DXStrParseNode;
import org.jruby.truffle.parser.ast.DefinedParseNode;
import org.jruby.truffle.parser.ast.DefnParseNode;
import org.jruby.truffle.parser.ast.DefsParseNode;
import org.jruby.truffle.parser.ast.DotParseNode;
import org.jruby.truffle.parser.ast.EncodingParseNode;
import org.jruby.truffle.parser.ast.EnsureParseNode;
import org.jruby.truffle.parser.ast.EvStrParseNode;
import org.jruby.truffle.parser.ast.FCallParseNode;
import org.jruby.truffle.parser.ast.FalseParseNode;
import org.jruby.truffle.parser.ast.FixnumParseNode;
import org.jruby.truffle.parser.ast.FlipParseNode;
import org.jruby.truffle.parser.ast.FloatParseNode;
import org.jruby.truffle.parser.ast.ForParseNode;
import org.jruby.truffle.parser.ast.GlobalAsgnParseNode;
import org.jruby.truffle.parser.ast.GlobalVarParseNode;
import org.jruby.truffle.parser.ast.HashParseNode;
import org.jruby.truffle.parser.ast.IArgumentNode;
import org.jruby.truffle.parser.ast.IfParseNode;
import org.jruby.truffle.parser.ast.InstAsgnParseNode;
import org.jruby.truffle.parser.ast.InstVarParseNode;
import org.jruby.truffle.parser.ast.IterParseNode;
import org.jruby.truffle.parser.ast.LambdaParseNode;
import org.jruby.truffle.parser.ast.ListParseNode;
import org.jruby.truffle.parser.ast.LiteralParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.LocalVarParseNode;
import org.jruby.truffle.parser.ast.Match2ParseNode;
import org.jruby.truffle.parser.ast.Match3ParseNode;
import org.jruby.truffle.parser.ast.MatchParseNode;
import org.jruby.truffle.parser.ast.MethodDefParseNode;
import org.jruby.truffle.parser.ast.ModuleParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.NextParseNode;
import org.jruby.truffle.parser.ast.NilImplicitParseNode;
import org.jruby.truffle.parser.ast.NilParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.NthRefParseNode;
import org.jruby.truffle.parser.ast.OpAsgnAndParseNode;
import org.jruby.truffle.parser.ast.OpAsgnConstDeclParseNode;
import org.jruby.truffle.parser.ast.OpAsgnOrParseNode;
import org.jruby.truffle.parser.ast.OpAsgnParseNode;
import org.jruby.truffle.parser.ast.OpElementAsgnParseNode;
import org.jruby.truffle.parser.ast.OrParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.PostExeParseNode;
import org.jruby.truffle.parser.ast.PreExeParseNode;
import org.jruby.truffle.parser.ast.RationalParseNode;
import org.jruby.truffle.parser.ast.RedoParseNode;
import org.jruby.truffle.parser.ast.RegexpParseNode;
import org.jruby.truffle.parser.ast.RescueBodyParseNode;
import org.jruby.truffle.parser.ast.RescueParseNode;
import org.jruby.truffle.parser.ast.RetryParseNode;
import org.jruby.truffle.parser.ast.ReturnParseNode;
import org.jruby.truffle.parser.ast.SClassParseNode;
import org.jruby.truffle.parser.ast.SValueParseNode;
import org.jruby.truffle.parser.ast.SelfParseNode;
import org.jruby.truffle.parser.ast.SideEffectFree;
import org.jruby.truffle.parser.ast.SplatParseNode;
import org.jruby.truffle.parser.ast.StarParseNode;
import org.jruby.truffle.parser.ast.StrParseNode;
import org.jruby.truffle.parser.ast.SymbolParseNode;
import org.jruby.truffle.parser.ast.TrueParseNode;
import org.jruby.truffle.parser.ast.TruffleFragmentParseNode;
import org.jruby.truffle.parser.ast.UndefParseNode;
import org.jruby.truffle.parser.ast.UntilParseNode;
import org.jruby.truffle.parser.ast.VAliasParseNode;
import org.jruby.truffle.parser.ast.VCallParseNode;
import org.jruby.truffle.parser.ast.WhenParseNode;
import org.jruby.truffle.parser.ast.WhileParseNode;
import org.jruby.truffle.parser.ast.XStrParseNode;
import org.jruby.truffle.parser.ast.YieldParseNode;
import org.jruby.truffle.parser.ast.ZArrayParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.parser.ParserSupport;
import org.jruby.truffle.parser.scope.StaticScope;
import org.jruby.truffle.platform.graal.AssertConstantNode;
import org.jruby.truffle.platform.graal.AssertConstantNodeGen;
import org.jruby.truffle.platform.graal.AssertNotCompiledNode;
import org.jruby.truffle.platform.graal.AssertNotCompiledNodeGen;
import org.jruby.truffle.tools.ChaosNodeGen;

public class BodyTranslator
extends Translator {
    protected final BodyTranslator parent;
    protected final TranslatorEnvironment environment;
    public boolean translatingForStatement = false;
    private boolean translatingNextExpression = false;
    private boolean translatingWhile = false;
    protected String currentCallMethodName = null;
    private boolean privately = false;
    public static final Object BAD_FRAME_SLOT = new Object();
    public Deque<Object> frameOnStackMarkerSlotStack = new ArrayDeque<Object>();
    private final ParserSupport parserSupport;

    public BodyTranslator(Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, Source source, boolean topLevel) {
        super(currentNode, context, source);
        this.parserSupport = new ParserSupport(context, source.getName());
        this.parent = parent;
        this.environment = environment;
    }

    private DynamicObject translateNameNodeToSymbol(ParseNode node) {
        return this.context.getSymbolTable().getSymbol(((LiteralParseNode)node).getName());
    }

    @Override
    public RubyNode visitAliasNode(AliasParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        DynamicObject oldName = this.translateNameNodeToSymbol(node.getOldName());
        DynamicObject newName = this.translateNameNodeToSymbol(node.getNewName());
        if (newName.toString().equals("allocate") && this.source.getName().endsWith("/ostruct.rb")) {
            return this.nilNode(this.source, sourceSection);
        }
        ObjectLiteralNode newNameNode = new ObjectLiteralNode(newName);
        newNameNode.unsafeSetSourceSection(sourceSection);
        ObjectLiteralNode oldNameNode = new ObjectLiteralNode(oldName);
        oldNameNode.unsafeSetSourceSection(sourceSection);
        ModuleNodes.AliasMethodNode ret = ModuleNodesFactory.AliasMethodNodeFactory.create(new RaiseIfFrozenNode(new GetDefaultDefineeNode()), newNameNode, oldNameNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitVAliasNode(VAliasParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        AliasGlobalVarNode ret = new AliasGlobalVarNode(node.getOldName(), node.getNewName());
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitAndNode(AndParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode x = this.translateNodeOrNil(sourceSection, node.getFirstNode());
        RubyNode y = this.translateNodeOrNil(sourceSection, node.getSecondNode());
        AndNode ret = new AndNode(x, y);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitArgsCatNode(ArgsCatParseNode node) {
        ArrayList<ParseNode> nodes = new ArrayList<ParseNode>();
        this.collectArgsCatNodes(nodes, node);
        ArrayList<RubyNode> translatedNodes = new ArrayList<RubyNode>();
        for (ParseNode catNode : nodes) {
            translatedNodes.add(catNode.accept(this));
        }
        ArrayConcatNode ret = new ArrayConcatNode(translatedNodes.toArray(new RubyNode[translatedNodes.size()]));
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    private void collectArgsCatNodes(List<ParseNode> nodes, ArgsCatParseNode node) {
        if (node.getFirstNode() instanceof ArgsCatParseNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatParseNode)node.getFirstNode());
        } else {
            nodes.add(node.getFirstNode());
        }
        if (node.getSecondNode() instanceof ArgsCatParseNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatParseNode)node.getSecondNode());
        } else {
            SplatParseNode secondNode = new SplatParseNode(node.getSecondNode().getPosition(), node.getSecondNode());
            nodes.add(secondNode);
        }
    }

    @Override
    public RubyNode visitArgsPushNode(ArgsPushParseNode node) {
        RubyNode args = node.getFirstNode().accept(this);
        RubyNode value = node.getSecondNode().accept(this);
        ArrayAppendOneNode ret = ArrayAppendOneNodeGen.create(KernelNodesFactory.DupNodeFactory.create(new RubyNode[]{args}), value);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitArrayNode(ArrayParseNode node) {
        ParseNode[] values = node.children();
        RubyNode[] translatedValues = new RubyNode[values.length];
        for (int n = 0; n < values.length; ++n) {
            translatedValues[n] = values[n].accept(this);
        }
        ArrayLiteralNode ret = ArrayLiteralNode.create(translatedValues);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitAttrAssignNode(AttrAssignParseNode node) {
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), node.getName(), node.getArgsNode(), null, node.isLazy());
        this.copyNewline(node, callNode);
        boolean isAccessorOnSelf = node.getReceiverNode() instanceof SelfParseNode;
        RubyNode actualCall = this.translateCallNode(callNode, isAccessorOnSelf, false, true);
        return this.addNewlineIfNeeded(node, actualCall);
    }

    @Override
    public RubyNode visitBeginNode(BeginParseNode node) {
        RubyNode ret = node.getBodyNode().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBignumNode(BignumParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        BigInteger value = node.getValue();
        RubyNode ret = value.bitLength() >= 64 ? new ObjectLiteralNode(BignumOperations.createBignum(this.context, node.getValue())) : new LongFixnumLiteralNode(value.longValue());
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBlockNode(BlockParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ArrayList<RubyNode> translatedChildren = new ArrayList<RubyNode>();
        int start = node.getPosition().getCharIndex();
        int end = node.getPosition().getCharEnd();
        for (ParseNode child : node.children()) {
            RubyNode translatedChild;
            if (child.getPosition() != null) {
                end = Math.max(end, child.getPosition().getCharEnd());
            }
            if ((translatedChild = this.translateNodeOrNil(sourceSection, child)) instanceof DeadNode) continue;
            translatedChildren.add(translatedChild);
        }
        RubyNode ret = translatedChildren.size() == 1 ? (RubyNode)((Object)translatedChildren.get(0)) : BodyTranslator.sequence(new SourceIndexLength(start, end - start), translatedChildren);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBreakNode(BreakParseNode node) {
        assert (this.environment.isBlock() || this.translatingWhile) : "The parser did not see an invalid break";
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode resultNode = this.translateNodeOrNil(sourceSection, node.getValueNode());
        BreakNode ret = new BreakNode(this.environment.getBreakID(), this.translatingWhile, resultNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitCallNode(CallParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ParseNode receiver = node.getReceiverNode();
        String methodName = node.getName();
        if (receiver instanceof StrParseNode && methodName.equals("freeze")) {
            StrParseNode strNode = (StrParseNode)receiver;
            ParserByteList byteList = strNode.getValue();
            CodeRange codeRange = strNode.getCodeRange();
            Rope rope = this.context.getRopeTable().getRope(byteList, codeRange);
            DynamicObject frozenString = this.context.getFrozenStrings().getFrozenString(rope);
            return this.addNewlineIfNeeded(node, Translator.withSourceSection(sourceSection, new DefinedWrapperNode(this.context.getCoreStrings().METHOD, new ObjectLiteralNode(frozenString))));
        }
        if (receiver instanceof ConstParseNode && ((ConstParseNode)receiver).getName().equals("Truffle")) {
            if (methodName.equals("primitive")) {
                throw new AssertionError((Object)("Invalid usage of Truffle.primitive at " + RubyLanguage.fileLine(fullSourceSection)));
            }
            if (methodName.equals("invoke_primitive")) {
                RubyNode ret = this.translateRubiniusInvokePrimitive(sourceSection, node);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("privately")) {
                RubyNode ret = this.translateRubiniusPrivately(fullSourceSection, node);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("single_block_arg")) {
                RubyNode ret = this.translateSingleBlockArg(sourceSection, node);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("check_frozen")) {
                RubyNode ret = this.translateCheckFrozen(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        } else if (receiver instanceof Colon2ConstParseNode && ((Colon2ConstParseNode)receiver).getLeftNode() instanceof ConstParseNode && ((ConstParseNode)((Colon2ConstParseNode)receiver).getLeftNode()).getName().equals("Truffle") && ((Colon2ConstParseNode)receiver).getName().equals("Graal")) {
            if (methodName.equals("assert_constant")) {
                AssertConstantNode ret = AssertConstantNodeGen.create(((ArrayParseNode)node.getArgsNode()).get(0).accept(this));
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("assert_not_compiled")) {
                AssertNotCompiledNode ret = AssertNotCompiledNodeGen.create();
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        } else if (receiver instanceof VCallParseNode && ((VCallParseNode)receiver).getName().equals("undefined") && this.getSourcePath(sourceSection).startsWith(this.corePath()) && methodName.equals("equal?")) {
            RubyNode argument = this.translateArgumentsAndBlock(sourceSection, null, node.getArgsNode(), methodName).getArguments()[0];
            IsRubiniusUndefinedNode ret = new IsRubiniusUndefinedNode(argument);
            ret.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, ret);
        }
        return this.translateCallNode(node, false, false, false);
    }

    protected RubyNode translateRubiniusPrimitive(SourceIndexLength sourceSection, BlockParseNode body, RubyNode loadArguments) {
        CallParseNode node = (CallParseNode)body.get(0);
        ArrayParseNode argsNode = (ArrayParseNode)node.getArgsNode();
        if (argsNode.size() != 1 || !(argsNode.get(0) instanceof SymbolParseNode)) {
            throw new UnsupportedOperationException("Truffle.primitive must have a single literal symbol argument");
        }
        String primitiveName = ((SymbolParseNode)argsNode.get(0)).getName();
        BlockParseNode fallback = new BlockParseNode(body.getPosition());
        for (int i = 1; i < body.size(); ++i) {
            fallback.add(body.get(i));
        }
        RubyNode fallbackNode = fallback.accept(this);
        fallbackNode = BodyTranslator.sequence(sourceSection, Arrays.asList(loadArguments, fallbackNode));
        PrimitiveNodeConstructor primitive = this.context.getPrimitiveManager().getPrimitive(primitiveName);
        return primitive.createCallPrimitiveNode(this.context, this.source, sourceSection, fallbackNode);
    }

    private RubyNode translateRubiniusInvokePrimitive(SourceIndexLength sourceSection, CallParseNode node) {
        ArrayParseNode args = (ArrayParseNode)node.getArgsNode();
        if (args.size() < 1 || !(args.get(0) instanceof SymbolParseNode)) {
            throw new UnsupportedOperationException("Truffle.invoke_primitive must have at least an initial literal symbol argument");
        }
        String primitiveName = ((SymbolParseNode)args.get(0)).getName();
        PrimitiveNodeConstructor primitive = this.context.getPrimitiveManager().getPrimitive(primitiveName);
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>();
        for (int n = 1; n < args.size(); ++n) {
            RubyNode readArgumentNode = args.get(n).accept(this);
            arguments.add(readArgumentNode);
        }
        return primitive.createInvokePrimitiveNode(this.context, this.source, sourceSection, arguments.toArray(new RubyNode[arguments.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateRubiniusPrivately(SourceSection sourceSection, CallParseNode node) {
        if (!(node.getIterNode() instanceof IterParseNode)) {
            throw new UnsupportedOperationException("Truffle.privately needs a literal block");
        }
        ArrayParseNode argsNode = (ArrayParseNode)node.getArgsNode();
        if (argsNode != null && argsNode.size() > 0) {
            throw new UnsupportedOperationException("Truffle.privately should not have any arguments");
        }
        this.currentCallMethodName = "privately";
        boolean previousPrivately = this.privately;
        this.privately = true;
        try {
            RubyNode rubyNode = ((IterParseNode)node.getIterNode()).getBodyNode().accept(this);
            return rubyNode;
        }
        finally {
            this.privately = previousPrivately;
        }
    }

    public RubyNode translateSingleBlockArg(SourceIndexLength sourceSection, CallParseNode node) {
        SingleBlockArgNode ret = new SingleBlockArgNode();
        ret.unsafeSetSourceSection(sourceSection);
        return ret;
    }

    private RubyNode translateCheckFrozen(SourceIndexLength sourceSection) {
        return Translator.withSourceSection(sourceSection, new RaiseIfFrozenNode(new SelfNode(this.environment.getFrameDescriptor())));
    }

    private RubyNode translateCallNode(CallParseNode node, boolean ignoreVisibility, boolean isVCall, boolean isAttrAssign) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode receiver = node.getReceiverNode().accept(this);
        ParseNode args = node.getArgsNode();
        ParseNode block = node.getIterNode();
        if (block == null && args instanceof IterParseNode) {
            block = args;
            args = null;
        }
        String methodName = node.getName();
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, block, args, methodName);
        ArrayList<RubyNode> children = new ArrayList<RubyNode>();
        if (argumentsAndBlock.getBlock() != null) {
            children.add(argumentsAndBlock.getBlock());
        }
        children.addAll(Arrays.asList(argumentsAndBlock.getArguments()));
        SourceIndexLength enclosingSourceSection = BodyTranslator.enclosing(sourceSection, children.toArray(new RubyNode[children.size()]));
        RubyCallNodeParameters callParameters = new RubyCallNodeParameters(receiver, methodName, argumentsAndBlock.getBlock(), argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted(), this.privately || ignoreVisibility, isVCall, node.isLazy(), isAttrAssign);
        RubyNode translated = Translator.withSourceSection(enclosingSourceSection, this.context.getCoreMethods().createCallNode(this.source, callParameters));
        if (argumentsAndBlock.getBlock() instanceof BlockDefinitionNode) {
            BlockDefinitionNode blockDef = (BlockDefinitionNode)argumentsAndBlock.getBlock();
            translated = new FrameOnStackNode(translated, argumentsAndBlock.getFrameOnStackMarkerSlot());
            translated = new CatchBreakNode(blockDef.getBreakID(), translated);
        }
        return this.addNewlineIfNeeded(node, translated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArgumentsAndBlockTranslation translateArgumentsAndBlock(SourceIndexLength sourceSection, ParseNode iterNode, ParseNode argsNode, String nameToSetWhenTranslatingBlock) {
        FrameSlot frameOnStackMarkerSlot;
        RubyNode blockTranslated;
        assert (!(argsNode instanceof IterParseNode));
        ArrayList<ParseNode> arguments = new ArrayList<ParseNode>();
        ParseNode blockPassNode = null;
        boolean isSplatted = false;
        if (argsNode instanceof ListParseNode) {
            arguments.addAll(argsNode.childNodes());
        } else if (argsNode instanceof BlockPassParseNode) {
            BlockPassParseNode blockPass = (BlockPassParseNode)argsNode;
            ParseNode blockPassArgs = blockPass.getArgsNode();
            if (blockPassArgs instanceof ListParseNode) {
                arguments.addAll(blockPassArgs.childNodes());
            } else if (blockPassArgs instanceof ArgsCatParseNode) {
                arguments.add(blockPassArgs);
            } else if (blockPassArgs != null) {
                throw new UnsupportedOperationException("Don't know how to block pass " + blockPassArgs);
            }
            blockPassNode = blockPass.getBodyNode();
        } else if (argsNode instanceof SplatParseNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode instanceof ArgsCatParseNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode != null) {
            isSplatted = true;
            arguments.add(argsNode);
        }
        RubyNode[] argumentsTranslated = new RubyNode[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            argumentsTranslated[i] = ((ParseNode)arguments.get(i)).accept(this);
        }
        if (iterNode instanceof BlockPassParseNode) {
            blockPassNode = ((BlockPassParseNode)iterNode).getBodyNode();
        }
        this.currentCallMethodName = nameToSetWhenTranslatingBlock;
        if (blockPassNode != null) {
            blockTranslated = ToProcNodeGen.create(blockPassNode.accept(this));
            blockTranslated.unsafeSetSourceSection(sourceSection);
            frameOnStackMarkerSlot = null;
        } else if (iterNode != null) {
            frameOnStackMarkerSlot = this.environment.declareVar(this.environment.allocateLocalTemp("frame_on_stack_marker"));
            this.frameOnStackMarkerSlotStack.push(frameOnStackMarkerSlot);
            try {
                blockTranslated = iterNode.accept(this);
            }
            finally {
                this.frameOnStackMarkerSlotStack.pop();
            }
            if (blockTranslated instanceof ObjectLiteralNode && ((ObjectLiteralNode)blockTranslated).getObject() == this.context.getCoreLibrary().getNilObject()) {
                blockTranslated = null;
            }
        } else {
            blockTranslated = null;
            frameOnStackMarkerSlot = null;
        }
        return new ArgumentsAndBlockTranslation(blockTranslated, argumentsTranslated, isSplatted, frameOnStackMarkerSlot);
    }

    @Override
    public RubyNode visitCaseNode(CaseParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode elseNode = this.translateNodeOrNil(sourceSection, node.getElseNode());
        if (node.getCaseNode() != null) {
            String tempName = this.environment.allocateLocalTemp("case");
            ReadLocalNode readTemp = this.environment.findLocalVarNode(tempName, this.source, sourceSection);
            RubyNode assignTemp = readTemp.makeWriteNode(node.getCaseNode().accept(this));
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenParseNode when = (WhenParseNode)node.getCases().get(n);
                List<ParseNode> expressions = when.getExpressionNodes() instanceof ListParseNode && !(when.getExpressionNodes() instanceof ArrayParseNode) ? when.getExpressionNodes().childNodes() : Collections.singletonList(when.getExpressionNodes());
                ArrayList<RubyCallNode> comparisons = new ArrayList<RubyCallNode>();
                for (ParseNode expressionNode : expressions) {
                    RubyNode[] arguments;
                    String method;
                    RubyNode receiver;
                    RubyNode rubyExpression = expressionNode.accept(this);
                    if (expressionNode instanceof SplatParseNode || expressionNode instanceof ArgsCatParseNode || expressionNode instanceof ArgsPushParseNode) {
                        receiver = new ObjectLiteralNode(this.context.getCoreLibrary().getTruffleModule());
                        receiver.unsafeSetSourceSection(sourceSection);
                        method = "when_splat";
                        arguments = new RubyNode[]{rubyExpression, (RubyNode)NodeUtil.cloneNode((Node)readTemp)};
                    } else {
                        receiver = rubyExpression;
                        method = "===";
                        arguments = new RubyNode[]{(RubyNode)NodeUtil.cloneNode((Node)readTemp)};
                    }
                    RubyCallNodeParameters callParameters = new RubyCallNodeParameters(receiver, method, null, arguments, false, true);
                    comparisons.add(Translator.withSourceSection(sourceSection, new RubyCallNode(callParameters)));
                }
                RubyNode conditionNode = (RubyNode)((Object)comparisons.get(comparisons.size() - 1));
                for (int i = comparisons.size() - 2; i >= 0; --i) {
                    conditionNode = new OrNode((RubyNode)((Object)comparisons.get(i)), conditionNode);
                }
                RubyNode thenNode = this.translateNodeOrNil(sourceSection, when.getBodyNode());
                IfElseNode ifNode = new IfElseNode(conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            RubyNode ifNode = elseNode;
            ret = BodyTranslator.sequence(sourceSection, Arrays.asList(assignTemp, ifNode));
        } else {
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenParseNode when = (WhenParseNode)node.getCases().get(n);
                List<ParseNode> expressions = when.getExpressionNodes() instanceof ListParseNode ? when.getExpressionNodes().childNodes() : Collections.singletonList(when.getExpressionNodes());
                ArrayList<RubyNode> tests = new ArrayList<RubyNode>();
                for (ParseNode expressionNode : expressions) {
                    RubyNode rubyExpression = expressionNode.accept(this);
                    tests.add(rubyExpression);
                }
                RubyNode conditionNode = (RubyNode)((Object)tests.get(tests.size() - 1));
                for (int i = tests.size() - 2; i >= 0; --i) {
                    conditionNode = new OrNode((RubyNode)((Object)tests.get(i)), conditionNode);
                }
                RubyNode thenNode = when.getBodyNode().accept(this);
                IfElseNode ifNode = new IfElseNode(conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            ret = elseNode;
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode openModule(SourceIndexLength sourceSection, RubyNode defineOrGetNode, String name, ParseNode bodyNode, boolean sclass) {
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        LexicalScope newLexicalScope = this.environment.pushLexicalScope();
        try {
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(fullSourceSection, newLexicalScope, Arity.NO_ARGUMENTS, null, name, sclass ? "class body" : "module body", null, false, false, false);
            ReturnID returnId = sclass ? this.environment.getReturnID() : this.environment.getParseEnvironment().allocateReturnID();
            TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), returnId, true, true, true, sharedMethodInfo, name, 0, null);
            BodyTranslator moduleTranslator = new BodyTranslator(this.currentNode, this.context, this, newEnvironment, this.source, false);
            ModuleBodyDefinitionNode definition = moduleTranslator.compileClassNode(sourceSection, name, bodyNode, sclass);
            RunModuleDefinitionNode runModuleDefinitionNode = Translator.withSourceSection(sourceSection, new RunModuleDefinitionNode(newLexicalScope, definition, defineOrGetNode));
            return runModuleDefinitionNode;
        }
        finally {
            this.environment.popLexicalScope();
        }
    }

    private ModuleBodyDefinitionNode compileClassNode(SourceIndexLength sourceSection, String name, ParseNode bodyNode, boolean sclass) {
        RubyNode body = this.translateNodeOrNil(sourceSection, bodyNode);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = BodyTranslator.sequence(sourceSection, Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        RubyNode writeSelfNode = BodyTranslator.loadSelf(this.context, this.environment);
        body = BodyTranslator.sequence(sourceSection, Arrays.asList(writeSelfNode, body));
        if (this.context.getOptions().CHAOS) {
            body = ChaosNodeGen.create(body);
        }
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyRootNode rootNode = new RubyRootNode(this.context, fullSourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body, this.environment.needsDeclarationFrame());
        ModuleBodyDefinitionNode definitionNode = new ModuleBodyDefinitionNode(this.environment.getSharedMethodInfo().getName(), this.environment.getSharedMethodInfo(), (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNode), sclass, this.environment.isDynamicConstantLookup());
        definitionNode.unsafeSetSourceSection(sourceSection);
        return definitionNode;
    }

    @Override
    public RubyNode visitClassNode(ClassParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        RubyNode superClass = node.getSuperNode() != null ? node.getSuperNode().accept(this) : null;
        DefineClassNode defineOrGetClass = new DefineClassNode(name, lexicalParent, superClass);
        RubyNode ret = this.openModule(sourceSection, defineOrGetClass, name, node.getBodyNode(), false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitClassVarAsgnNode(ClassVarAsgnParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode rhs = node.getValueNode().accept(this);
        WriteClassVariableNode ret = new WriteClassVariableNode(this.environment.getLexicalScope(), node.getName(), rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitClassVarNode(ClassVarParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ReadClassVariableNode ret = new ReadClassVariableNode(this.environment.getLexicalScope(), node.getName());
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitColon2Node(Colon2ParseNode node) {
        if (!(node instanceof Colon2ConstParseNode)) {
            throw new UnsupportedOperationException(node.toString());
        }
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = ConstantReplacer.replacementName(fullSourceSection, node.getName());
        RubyNode lhs = node.getLeftNode().accept(this);
        ReadConstantNode ret = new ReadConstantNode(lhs, name);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitColon3Node(Colon3ParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = ConstantReplacer.replacementName(fullSourceSection, node.getName());
        ObjectLiteralNode root = new ObjectLiteralNode(this.context.getCoreLibrary().getObjectClass());
        root.unsafeSetSourceSection(sourceSection);
        ReadConstantNode ret = new ReadConstantNode(root, name);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode translateCPath(SourceIndexLength sourceSection, Colon3ParseNode node) {
        RubyNode ret;
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        if (node instanceof Colon2ImplicitParseNode) {
            if (this.environment.getParseEnvironment().isDynamicConstantLookup()) {
                if (this.context.getOptions().LOG_DYNAMIC_CONSTANT_LOOKUP) {
                    Log.LOGGER.info(() -> "dynamic constant lookup at " + RubyLanguage.fileLine(fullSourceSection));
                }
                ret = new DynamicLexicalScopeNode();
            } else {
                ret = new LexicalScopeNode(this.environment.getLexicalScope());
            }
            ret.unsafeSetSourceSection(sourceSection);
        } else if (node instanceof Colon2ConstParseNode) {
            ret = node.childNodes().get(0).accept(this);
        } else {
            ret = new ObjectLiteralNode(this.context.getCoreLibrary().getObjectClass());
            ret.unsafeSetSourceSection(sourceSection);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitComplexNode(ComplexParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode ret = this.translateRationalComplex(sourceSection, "Complex", new IntegerFixnumLiteralNode(0), node.getNumber().accept(this));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitConstDeclNode(ConstDeclParseNode node) {
        RubyNode moduleNode;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode rhs = node.getValueNode().accept(this);
        ParseNode constNode = node.getConstNode();
        if (constNode == null || constNode instanceof Colon2ImplicitParseNode) {
            if (this.environment.getParseEnvironment().isDynamicConstantLookup()) {
                if (this.context.getOptions().LOG_DYNAMIC_CONSTANT_LOOKUP) {
                    Log.LOGGER.info(() -> "set dynamic constant at " + RubyLanguage.fileLine(sourceSection.toSourceSection(this.source)));
                }
                moduleNode = new DynamicLexicalScopeNode();
            } else {
                moduleNode = new LexicalScopeNode(this.environment.getLexicalScope());
            }
            moduleNode.unsafeSetSourceSection(sourceSection);
        } else if (constNode instanceof Colon2ConstParseNode) {
            constNode = ((Colon2ParseNode)constNode).getLeftNode();
            moduleNode = constNode.accept(this);
        } else if (constNode instanceof Colon3ParseNode) {
            moduleNode = new ObjectLiteralNode(this.context.getCoreLibrary().getObjectClass());
        } else {
            throw new UnsupportedOperationException();
        }
        WriteConstantNode ret = new WriteConstantNode(node.getName(), moduleNode, rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private String getSourcePath(SourceIndexLength sourceSection) {
        if (sourceSection == null) {
            return "(unknown)";
        }
        if (this.source == null) {
            return "(unknown)";
        }
        String path = this.source.getName();
        if (path == null) {
            return this.source.getName();
        }
        return path;
    }

    private String corePath() {
        return this.environment.getParseEnvironment().getCorePath();
    }

    private String buildPartialPath(String ... components) {
        StringBuilder ret = new StringBuilder();
        for (String component : components) {
            ret.append(File.separatorChar);
            ret.append(component);
        }
        return ret.toString();
    }

    @Override
    public RubyNode visitConstNode(ConstParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = ConstantReplacer.replacementName(fullSourceSection, node.getName());
        if (name.equals("Rubinius") && this.getSourcePath(sourceSection).startsWith(this.corePath())) {
            RubyNode ret2 = new Colon3ParseNode(node.getPosition(), name).accept(this);
            return this.addNewlineIfNeeded(node, ret2);
        }
        if (name.equals("RUBY_PLATFORM") && this.getSourcePath(sourceSection).contains(this.buildPartialPath("test", "xml_mini", "jdom_engine_test.rb"))) {
            ObjectLiteralNode ret3 = new ObjectLiteralNode(StringOperations.createString(this.context, StringOperations.encodeRope("truffle", (Encoding)UTF8Encoding.INSTANCE, CodeRange.CR_7BIT)));
            ret3.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, ret3);
        }
        if (this.environment.getParseEnvironment().isDynamicConstantLookup()) {
            if (this.context.getOptions().LOG_DYNAMIC_CONSTANT_LOOKUP) {
                Log.LOGGER.info(() -> "dynamic constant lookup at " + RubyLanguage.fileLine(fullSourceSection));
            }
            ret = new ReadConstantWithDynamicScopeNode(name);
        } else {
            LexicalScope lexicalScope = this.environment.getLexicalScope();
            ret = new ReadConstantWithLexicalScopeNode(lexicalScope, name);
        }
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDAsgnNode(DAsgnParseNode node) {
        RubyNode ret = new LocalAsgnParseNode(node.getPosition(), node.getName(), node.getDepth(), node.getValueNode()).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDRegxNode(DRegexpParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ArrayList<RubyNode> children = new ArrayList<RubyNode>();
        for (ParseNode child : node.children()) {
            children.add(child.accept(this));
        }
        InterpolatedRegexpNode i = new InterpolatedRegexpNode(children.toArray(new RubyNode[children.size()]), node.getOptions());
        i.unsafeSetSourceSection(sourceSection);
        if (node.getOptions().isOnce()) {
            OnceNode ret = new OnceNode(i);
            ret.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, ret);
        }
        return this.addNewlineIfNeeded(node, i);
    }

    @Override
    public RubyNode visitDStrNode(DStrParseNode node) {
        RubyNode ret = this.translateInterpolatedString(node.getPosition(), node.children());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDSymbolNode(DSymbolParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode stringNode = this.translateInterpolatedString(sourceSection, node.children());
        StringToSymbolNode ret = StringToSymbolNodeGen.create(stringNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode translateInterpolatedString(SourceIndexLength sourceSection, ParseNode[] childNodes) {
        ToSNode[] children = new ToSNode[childNodes.length];
        for (int i = 0; i < childNodes.length; ++i) {
            children[i] = ToSNodeGen.create(childNodes[i].accept(this));
        }
        InterpolatedStringNode ret = new InterpolatedStringNode(children);
        ret.unsafeSetSourceSection(sourceSection);
        return ret;
    }

    @Override
    public RubyNode visitDVarNode(DVarParseNode node) {
        ReadLocalNode readNode = this.environment.findLocalVarNode(node.getName(), this.source, node.getPosition());
        if (readNode == null) {
            int depth = node.getDepth();
            TranslatorEnvironment e = this.environment;
            for (int n = 0; n < depth; ++n) {
                e = e.getParent();
            }
            e.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(node.getName(), this.source, node.getPosition());
        }
        return this.addNewlineIfNeeded(node, readNode);
    }

    @Override
    public RubyNode visitDXStrNode(DXStrParseNode node) {
        DStrParseNode string = new DStrParseNode(node.getPosition(), node.getEncoding());
        string.addAll(node);
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), string, new ParseNode[0]);
        FCallParseNode callNode = new FCallParseNode(node.getPosition(), "`", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefinedNode(DefinedParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        DefinedNode ret = new DefinedNode(node.getExpressionNode().accept(this));
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefnNode(DefnParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RaiseIfFrozenNode classNode = new RaiseIfFrozenNode(new GetDefaultDefineeNode());
        String methodName = node.getName();
        RubyNode ret = this.translateMethodDefinition(sourceSection, classNode, methodName, node.getArgsNode(), node, node.getBodyNode(), false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefsNode(DefsParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode objectNode = node.getReceiverNode().accept(this);
        SingletonClassNode singletonClassNode = SingletonClassNodeGen.create(objectNode);
        singletonClassNode.unsafeSetSourceSection(sourceSection);
        RubyNode ret = this.translateMethodDefinition(sourceSection, singletonClassNode, node.getName(), node.getArgsNode(), node, node.getBodyNode(), true);
        return this.addNewlineIfNeeded(node, ret);
    }

    protected RubyNode translateMethodDefinition(SourceIndexLength sourceSection, RubyNode classNode, String methodName, ArgsParseNode argsNode, MethodDefParseNode defNode, ParseNode bodyNode, boolean isDefs) {
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        Arity arity = MethodTranslator.getArity(argsNode);
        ArgumentDescriptor[] argumentDescriptors = Helpers.argsNodeToArgumentDescriptors(argsNode);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection.toSourceSection(this.source), this.environment.getLexicalScopeOrNull(), arity, null, methodName, null, argumentDescriptors, false, false, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), this.environment.getParseEnvironment().allocateReturnID(), true, true, false, sharedMethodInfo, methodName, 0, null);
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, false, this.source, argsNode);
        MethodDefinitionNode methodDefinitionNode = methodCompiler.compileMethodNode(sourceSection, methodName, defNode, bodyNode, sharedMethodInfo);
        RubyNode visibilityNode = isDefs ? new ObjectLiteralNode((Object)Visibility.PUBLIC) : new GetCurrentVisibilityNode();
        return BodyTranslator.withSourceSection(sourceSection, AddMethodNodeGen.create(isDefs, true, classNode, methodDefinitionNode, visibilityNode));
    }

    @Override
    public RubyNode visitDotNode(DotParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode begin = node.getBeginNode().accept(this);
        RubyNode end = node.getEndNode().accept(this);
        ObjectLiteralNode rangeClass = new ObjectLiteralNode(this.context.getCoreLibrary().getRangeClass());
        ObjectLiteralNode isExclusive = new ObjectLiteralNode(node.isExclusive());
        RangeNodes.NewNode ret = RangeNodesFactory.NewNodeFactory.create(rangeClass, begin, end, isExclusive);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEncodingNode(EncodingParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        ObjectLiteralNode ret = new ObjectLiteralNode(this.context.getEncodingManager().getRubyEncoding(node.getEncoding()));
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEnsureNode(EnsureParseNode node) {
        RubyNode tryPart = node.getBodyNode().accept(this);
        RubyNode ensurePart = node.getEnsureNode().accept(this);
        EnsureNode ret = new EnsureNode(tryPart, ensurePart);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEvStrNode(EvStrParseNode node) {
        RubyNode ret;
        if (node.getBody() == null) {
            SourceIndexLength sourceSection = node.getPosition();
            ret = new ObjectLiteralNode(StringOperations.createString(this.context, RopeConstants.EMPTY_ASCII_8BIT_ROPE));
            ret.unsafeSetSourceSection(sourceSection);
        } else {
            ret = node.getBody().accept(this);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFCallNode(FCallParseNode node) {
        SelfParseNode receiver = new SelfParseNode(node.getPosition());
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, node.getName(), node.getArgsNode(), node.getIterNode());
        this.copyNewline(node, callNode);
        return this.translateCallNode(callNode, true, false, false);
    }

    @Override
    public RubyNode visitFalseNode(FalseParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        BooleanLiteralNode ret = new BooleanLiteralNode(false);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFixnumNode(FixnumParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        long value = node.getValue();
        RubyNode ret = CoreLibrary.fitsIntoInteger(value) ? new IntegerFixnumLiteralNode((int)value) : new LongFixnumLiteralNode(value);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFlipNode(FlipParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode begin = node.getBeginNode().accept(this);
        RubyNode end = node.getEndNode().accept(this);
        FlipFlopStateNode stateNode = this.createFlipFlopState(sourceSection, 0);
        FlipFlopNode ret = new FlipFlopNode(begin, end, stateNode, node.isExclusive());
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    protected FlipFlopStateNode createFlipFlopState(SourceIndexLength sourceSection, int depth) {
        FrameSlot frameSlot = this.environment.declareVar(this.environment.allocateLocalTemp("flipflop"));
        this.environment.getFlipFlopStates().add(frameSlot);
        if (depth == 0) {
            return new LocalFlipFlopStateNode(frameSlot);
        }
        return new DeclarationFlipFlopStateNode(depth, frameSlot);
    }

    @Override
    public RubyNode visitFloatNode(FloatParseNode node) {
        FloatLiteralNode ret = new FloatLiteralNode(node.getValue());
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitForNode(ForParseNode node) {
        String temp = this.environment.allocateLocalTemp("for");
        ParseNode receiver = node.getIterNode();
        LocalVarParseNode readTemp = new LocalVarParseNode(node.getPosition(), 0, temp);
        ParseNode forVar = node.getVarNode();
        ParseNode assignTemp = this.setRHS(forVar, readTemp);
        BlockParseNode bodyWithTempAssign = new BlockParseNode(node.getPosition());
        bodyWithTempAssign.add(assignTemp);
        bodyWithTempAssign.add(node.getBodyNode());
        ArgumentParseNode blockVar = new ArgumentParseNode(node.getPosition(), temp);
        ListParseNode blockArgsPre = new ListParseNode(node.getPosition(), blockVar);
        ArgsParseNode blockArgs = new ArgsParseNode(node.getPosition(), blockArgsPre, null, null, null, null, null, null);
        IterParseNode block = new IterParseNode(node.getPosition(), (ParseNode)blockArgs, node.getScope(), bodyWithTempAssign);
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, "each", null, block);
        this.copyNewline(node, callNode);
        this.translatingForStatement = true;
        RubyNode translated = callNode.accept(this);
        this.translatingForStatement = false;
        return this.addNewlineIfNeeded(node, translated);
    }

    private ParseNode setRHS(ParseNode node, ParseNode rhs) {
        if (node instanceof AssignableParseNode || node instanceof IArgumentNode) {
            return this.parserSupport.node_assign(node, rhs);
        }
        throw new UnsupportedOperationException("Don't know how to set the RHS of a " + node.getClass().getName());
    }

    private RubyNode translateDummyAssignment(ParseNode dummyAssignment, final RubyNode rhs) {
        if (dummyAssignment instanceof StarParseNode) {
            return rhs;
        }
        if (dummyAssignment instanceof AssignableParseNode || dummyAssignment instanceof IArgumentNode) {
            ParseNode wrappedRHS = new ParseNode(dummyAssignment.getPosition(), false){

                @Override
                public <T> T accept(NodeVisitor<T> visitor) {
                    return (T)((Object)rhs);
                }

                @Override
                public List<ParseNode> childNodes() {
                    return Collections.emptyList();
                }

                @Override
                public NodeType getNodeType() {
                    return NodeType.FIXNUMNODE;
                }
            };
            return this.setRHS(dummyAssignment, wrappedRHS).accept(this);
        }
        throw new UnsupportedOperationException("Don't know how to translate the dummy asgn " + dummyAssignment.getClass().getName());
    }

    @Override
    public RubyNode visitGlobalAsgnNode(GlobalAsgnParseNode node) {
        RubyNode translated;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode rhs = node.getValueNode().accept(this);
        String name = node.getName();
        if (GLOBAL_VARIABLE_ALIASES.containsKey(name)) {
            name = (String)GLOBAL_VARIABLE_ALIASES.get(name);
        }
        if (name.equals("$~")) {
            rhs = new CheckMatchVariableTypeNode(rhs);
            rhs = WrapInThreadLocalNodeGen.create(rhs);
            rhs.unsafeSetSourceSection(sourceSection);
            this.environment.declareVarInMethodScope("$~");
        } else if (name.equals("$0")) {
            rhs = new CheckProgramNameVariableTypeNode(rhs);
            rhs.unsafeSetSourceSection(sourceSection);
        } else if (name.equals("$/")) {
            rhs = new CheckRecordSeparatorVariableTypeNode(rhs);
            rhs.unsafeSetSourceSection(sourceSection);
        } else if (name.equals("$,")) {
            rhs = new CheckOutputSeparatorVariableTypeNode(rhs);
            rhs.unsafeSetSourceSection(sourceSection);
        } else if (name.equals("$_")) {
            rhs = this.getSourcePath(sourceSection).endsWith(this.buildPartialPath("truffle", "rubysl", "rubysl-stringio", "lib", "rubysl", "stringio", "stringio.rb")) ? RubiniusLastStringWriteNodeGen.create(rhs) : WrapInThreadLocalNodeGen.create(rhs);
            rhs.unsafeSetSourceSection(sourceSection);
            this.environment.declareVar("$_");
        } else if (name.equals("$stdout")) {
            rhs = new CheckStdoutVariableTypeNode(rhs);
            rhs.unsafeSetSourceSection(sourceSection);
        } else if (name.equals("$VERBOSE")) {
            rhs = new UpdateVerbosityNode(rhs);
            rhs.unsafeSetSourceSection(sourceSection);
        } else if (name.equals("$@")) {
            return BodyTranslator.withSourceSection(sourceSection, new UpdateLastBacktraceNode(rhs));
        }
        boolean inCore = this.getSourcePath(node.getValueNode().getPosition()).startsWith(this.corePath());
        if (!inCore && READ_ONLY_GLOBAL_VARIABLES.contains(name)) {
            return this.addNewlineIfNeeded(node, BodyTranslator.withSourceSection(sourceSection, new WriteReadOnlyGlobalNode(name, rhs)));
        }
        if (THREAD_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ThreadLocalObjectNode threadLocalVariablesObjectNode = ThreadLocalObjectNodeGen.create();
            threadLocalVariablesObjectNode.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, BodyTranslator.withSourceSection(sourceSection, new WriteInstanceVariableNode(name, threadLocalVariablesObjectNode, rhs)));
        }
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ReadLocalNode localVarNode;
            if (this.environment.getNeverAssignInParentScope()) {
                this.environment.declareVar(name);
            }
            if ((localVarNode = this.environment.findLocalVarNode(node.getName(), this.source, sourceSection)) == null) {
                if (this.environment.hasOwnScopeForAssignments()) {
                    this.environment.declareVar(node.getName());
                }
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
                localVarNode = this.environment.findLocalVarNode(node.getName(), this.source, sourceSection);
                if (localVarNode == null) {
                    throw new RuntimeException("shouldn't be here");
                }
            }
            RubyNode assignment = localVarNode.makeWriteNode(rhs);
            if (name.equals("$_") || name.equals("$~")) {
                assignment = BodyTranslator.withSourceSection(sourceSection, new GetFromThreadLocalNode(assignment));
            }
            return this.addNewlineIfNeeded(node, assignment);
        }
        WriteGlobalVariableNode writeGlobalVariableNode = BodyTranslator.withSourceSection(sourceSection, WriteGlobalVariableNodeGen.create(name, rhs));
        if (name.equals("$0")) {
            ObjectLiteralNode processClass = new ObjectLiteralNode(this.context.getCoreLibrary().getProcessModule());
            translated = new RubyCallNode(new RubyCallNodeParameters(processClass, "setproctitle", null, new RubyNode[]{writeGlobalVariableNode}, false, false));
            translated.unsafeSetSourceSection(sourceSection);
        } else {
            translated = writeGlobalVariableNode;
        }
        return this.addNewlineIfNeeded(node, translated);
    }

    @Override
    public RubyNode visitGlobalVarNode(GlobalVarParseNode node) {
        RubyNode ret;
        String name = node.getName();
        if (GLOBAL_VARIABLE_ALIASES.containsKey(name)) {
            name = (String)GLOBAL_VARIABLE_ALIASES.get(name);
        }
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            RubyNode readNode = this.environment.findLocalVarNode(name, this.source, sourceSection);
            if (readNode == null) {
                this.environment.declareVarInMethodScope(name);
                readNode = this.environment.findLocalVarNode(name, this.source, sourceSection);
            }
            if (name.equals("$_")) {
                if (this.getSourcePath(sourceSection).equals(this.corePath() + "regexp.rb")) {
                    readNode = new RubiniusLastStringReadNode();
                    readNode.unsafeSetSourceSection(sourceSection);
                } else {
                    readNode = new GetFromThreadLocalNode(readNode);
                    readNode.unsafeSetSourceSection(sourceSection);
                }
            } else if (name.equals("$~")) {
                readNode = new GetFromThreadLocalNode(readNode);
                readNode.unsafeSetSourceSection(sourceSection);
            }
            ret = readNode;
        } else if (THREAD_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ret = new ReadThreadLocalGlobalVariableNode(name, ALWAYS_DEFINED_GLOBALS.contains(name));
            ret.unsafeSetSourceSection(sourceSection);
        } else if (name.equals("$@")) {
            ret = new ReadLastBacktraceNode();
            ret.unsafeSetSourceSection(sourceSection);
        } else {
            ret = ReadGlobalVariableNodeGen.create(name);
            ret.unsafeSetSourceSection(sourceSection);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitHashNode(HashParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        ArrayList<RubyNode> hashConcats = new ArrayList<RubyNode>();
        ArrayList<RubyNode> keyValues = new ArrayList<RubyNode>();
        for (Tuple<ParseNode, ParseNode> pair : node.getPairs()) {
            if (pair.getKey() == null) {
                HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, keyValues.toArray(new RubyNode[keyValues.size()]));
                hashConcats.add(hashLiteralSoFar);
                hashConcats.add(new EnsureSymbolKeysNode(HashCastNodeGen.create(pair.getValue().accept(this))));
                keyValues.clear();
                continue;
            }
            keyValues.add(pair.getKey().accept(this));
            if (pair.getValue() == null) {
                keyValues.add(this.nilNode(this.source, sourceSection));
                continue;
            }
            keyValues.add(pair.getValue().accept(this));
        }
        HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, keyValues.toArray(new RubyNode[keyValues.size()]));
        hashConcats.add(hashLiteralSoFar);
        if (hashConcats.size() == 1) {
            ret = (RubyNode)((Object)hashConcats.get(0));
            return this.addNewlineIfNeeded(node, ret);
        }
        ret = new ConcatHashLiteralNode(hashConcats.toArray(new RubyNode[hashConcats.size()]));
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitIfNode(IfParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode condition = this.translateNodeOrNil(sourceSection, node.getCondition());
        ParseNode thenBody = node.getThenBody();
        ParseNode elseBody = node.getElseBody();
        if (thenBody != null && elseBody != null) {
            RubyNode thenBodyTranslated = thenBody.accept(this);
            RubyNode elseBodyTranslated = elseBody.accept(this);
            ret = new IfElseNode(condition, thenBodyTranslated, elseBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else if (thenBody != null) {
            RubyNode thenBodyTranslated = thenBody.accept(this);
            ret = new IfNode(condition, thenBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else if (elseBody != null) {
            RubyNode elseBodyTranslated = elseBody.accept(this);
            ret = new UnlessNode(condition, elseBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else {
            ret = BodyTranslator.sequence(sourceSection, Arrays.asList(new RubyNode[]{condition, new NilLiteralNode(true)}));
        }
        return ret;
    }

    @Override
    public RubyNode visitInstAsgnNode(InstAsgnParseNode node) {
        RubyNode rhs;
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        if (node.getValueNode() == null) {
            rhs = new DeadNode(new Exception("null RHS of instance variable assignment"));
            rhs.unsafeSetSourceSection(sourceSection);
        } else {
            rhs = node.getValueNode().accept(this);
        }
        RaiseIfFrozenNode self = new RaiseIfFrozenNode(new SelfNode(this.environment.getFrameDescriptor()));
        String path = this.getSourcePath(sourceSection);
        String corePath = this.corePath();
        if (path.equals(corePath + "hash.rb")) {
            if (name.equals("@default")) {
                HashNodes.SetDefaultValueNode ret = HashNodesFactory.SetDefaultValueNodeFactory.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@default_proc")) {
                HashNodes.SetDefaultProcNode ret = HashNodesFactory.SetDefaultProcNodeFactory.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        } else if (path.equals(corePath + "range.rb")) {
            if (name.equals("@begin")) {
                RangeNodes.InternalSetBeginNode ret = RangeNodesFactory.InternalSetBeginNodeGen.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@end")) {
                RangeNodes.InternalSetEndNode ret = RangeNodesFactory.InternalSetEndNodeGen.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@excl")) {
                RangeNodes.InternalSetExcludeEndNode ret = RangeNodesFactory.InternalSetExcludeEndNodeGen.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        } else if (path.equals(corePath + "io.rb") && (name.equals("@used") || name.equals("@total") || name.equals("@lineno"))) {
            WriteInstanceVariableNode ret = new WriteInstanceVariableNode(name, self, IntegerCastNodeGen.create(rhs));
            return this.addNewlineIfNeeded(node, ret);
        }
        WriteInstanceVariableNode ret = new WriteInstanceVariableNode(name, self, rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitInstVarNode(InstVarParseNode node) {
        String corePath;
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        SelfNode self = new SelfNode(this.environment.getFrameDescriptor());
        String path = this.getSourcePath(sourceSection);
        if (path.equals((corePath = this.corePath()) + "regexp.rb")) {
            if (name.equals("@source")) {
                MatchDataNodes.RubiniusSourceNode ret = MatchDataNodesFactory.RubiniusSourceNodeGen.create(self);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@regexp")) {
                MatchDataNodes.RegexpNode ret = MatchDataNodesFactory.RegexpNodeFactory.create(new RubyNode[]{self});
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        }
        ReadInstanceVariableNode ret = new ReadInstanceVariableNode(name, self);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitIterNode(IterParseNode node) {
        return this.translateBlockLikeNode(node, false);
    }

    @Override
    public RubyNode visitLambdaNode(LambdaParseNode node) {
        return this.translateBlockLikeNode(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateBlockLikeNode(IterParseNode node, boolean isLambda) {
        BlockDefinitionNode definitionNode;
        ProcType type;
        SourceIndexLength sourceSection = node.getPosition();
        ArgsParseNode argsNode = node.getArgsNode();
        boolean hasOwnScope = isLambda || !this.translatingForStatement;
        boolean isProc = !isLambda;
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection.toSourceSection(this.source), this.environment.getLexicalScopeOrNull(), MethodTranslator.getArity(argsNode), null, null, isLambda ? "lambda" : this.getIdentifierInNewEnvironment(true, this.currentCallMethodName), Helpers.argsNodeToArgumentDescriptors(argsNode), false, false, false);
        String namedMethodName = isLambda ? sharedMethodInfo.getName() : this.environment.getNamedMethodName();
        ParseEnvironment parseEnvironment = this.environment.getParseEnvironment();
        ReturnID returnID = isLambda ? parseEnvironment.allocateReturnID() : this.environment.getReturnID();
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, parseEnvironment, returnID, hasOwnScope, false, false, sharedMethodInfo, namedMethodName, this.environment.getBlockDepth() + 1, parseEnvironment.allocateBreakID());
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, true, this.source, argsNode);
        if (isProc) {
            methodCompiler.translatingForStatement = this.translatingForStatement;
        }
        methodCompiler.frameOnStackMarkerSlotStack = this.frameOnStackMarkerSlotStack;
        ProcType procType = type = isLambda ? ProcType.LAMBDA : ProcType.PROC;
        if (isLambda) {
            this.frameOnStackMarkerSlotStack.push(BAD_FRAME_SLOT);
        }
        try {
            definitionNode = methodCompiler.compileBlockNode(sourceSection, sharedMethodInfo.getName(), node.getBodyNode(), sharedMethodInfo, type, node.getScope().getVariables());
        }
        finally {
            if (isLambda) {
                this.frameOnStackMarkerSlotStack.pop();
            }
        }
        return this.addNewlineIfNeeded(node, definitionNode);
    }

    @Override
    public RubyNode visitLocalAsgnNode(LocalAsgnParseNode node) {
        RubyNode rhs;
        ReadLocalNode lhs;
        SourceIndexLength sourceSection = node.getPosition();
        if (this.environment.getNeverAssignInParentScope()) {
            this.environment.declareVar(node.getName());
        }
        if ((lhs = this.environment.findLocalVarNode(node.getName(), this.source, sourceSection)) == null) {
            if (this.environment.hasOwnScopeForAssignments()) {
                this.environment.declareVar(node.getName());
            } else {
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
            }
            lhs = this.environment.findLocalVarNode(node.getName(), this.source, sourceSection);
            if (lhs == null) {
                throw new RuntimeException("shouldn't be here");
            }
        }
        if (node.getValueNode() == null) {
            rhs = new DeadNode(new Exception());
            rhs.unsafeSetSourceSection(sourceSection);
        } else {
            rhs = node.getValueNode().accept(this);
        }
        RubyNode ret = lhs.makeWriteNode(rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitLocalVarNode(LocalVarParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getName();
        ReadLocalNode readNode = this.environment.findLocalVarNode(name, this.source, sourceSection);
        if (readNode == null) {
            this.environment.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(name, this.source, sourceSection);
        }
        return this.addNewlineIfNeeded(node, readNode);
    }

    @Override
    public RubyNode visitMatchNode(MatchParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), new GlobalVarParseNode(node.getPosition(), "$_"), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getRegexpNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitMatch2Node(Match2ParseNode node) {
        RegexpParseNode regexpNode;
        byte[] bytes;
        Regex regex;
        if (node.getReceiverNode() instanceof RegexpParseNode && (regex = new Regex(bytes = (regexpNode = (RegexpParseNode)node.getReceiverNode()).getValue().getBytes(), 0, bytes.length, regexpNode.getOptions().toOptions(), regexpNode.getEncoding(), Syntax.RUBY)).numberOfNames() > 0) {
            Iterator i = regex.namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(name);
            }
        }
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitMatch3Node(Match3ParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitModuleNode(ModuleParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        DefineModuleNode defineModuleNode = DefineModuleNodeGen.create(name, lexicalParent);
        RubyNode ret = this.openModule(sourceSection, defineModuleNode, name, node.getBodyNode(), false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnParseNode node) {
        ArrayList<RubyNode> sequence;
        RubyNode result;
        SourceIndexLength sourceSection = node.getPosition();
        ListParseNode preArray = node.getPre();
        ListParseNode postArray = node.getPost();
        ParseNode rhs = node.getValueNode();
        if (rhs == null) {
            throw new UnsupportedOperationException("null rhs");
        }
        RubyNode rhsTranslated = rhs.accept(this);
        if (preArray != null && node.getPost() == null && node.getRest() == null && rhsTranslated instanceof ArrayLiteralNode && ((ArrayLiteralNode)rhsTranslated).getSize() == preArray.size()) {
            ArrayLiteralNode rhsArrayLiteral = (ArrayLiteralNode)rhsTranslated;
            int assignedValuesCount = preArray.size();
            RubyNode[] sequence2 = new RubyNode[assignedValuesCount * 2];
            RubyNode[] tempValues = new RubyNode[assignedValuesCount];
            for (int n = 0; n < assignedValuesCount; ++n) {
                String tempName = this.environment.allocateLocalTemp("multi");
                ReadLocalNode readTemp = this.environment.findLocalVarNode(tempName, this.source, sourceSection);
                RubyNode assignTemp = readTemp.makeWriteNode(rhsArrayLiteral.stealNode(n));
                RubyNode assignFinalValue = this.translateDummyAssignment(preArray.get(n), (RubyNode)NodeUtil.cloneNode((Node)readTemp));
                sequence2[n] = assignTemp;
                sequence2[assignedValuesCount + n] = assignFinalValue;
                tempValues[n] = (RubyNode)NodeUtil.cloneNode((Node)readTemp);
            }
            RubyNode blockNode = BodyTranslator.sequence(sourceSection, Arrays.asList(sequence2));
            ArrayLiteralNode arrayNode = ArrayLiteralNode.create(tempValues);
            arrayNode.unsafeSetSourceSection(sourceSection);
            result = new ElidableResultNode(blockNode, arrayNode);
        } else if (preArray != null) {
            sequence = new ArrayList<RubyNode>();
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            String tempName = this.environment.allocateLocalTemp("array");
            SplatCastNode splatCastNode = SplatCastNodeGen.create(this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
            splatCastNode.unsafeSetSourceSection(sourceSection);
            RubyNode writeTemp = this.environment.findLocalVarNode(tempName, this.source, sourceSection).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            for (int n = 0; n < preArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.environment.findLocalVarNode(tempName, this.source, sourceSection), n);
                sequence.add(this.translateDummyAssignment(preArray.get(n), assignedValue));
            }
            if (node.getRest() != null) {
                RubyNode assignedValue = ArrayGetTailNodeGen.create(preArray.size(), this.environment.findLocalVarNode(tempName, this.source, sourceSection));
                if (postArray != null) {
                    assignedValue = ArrayDropTailNodeGen.create(postArray.size(), assignedValue);
                }
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            if (postArray != null) {
                ArrayList<RubyNode> smallerSequence = new ArrayList<RubyNode>();
                for (int n = 0; n < postArray.size(); ++n) {
                    RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.environment.findLocalVarNode(tempName, this.source, sourceSection), node.getPreCount() + n);
                    smallerSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
                }
                RubyNode smaller = BodyTranslator.sequence(sourceSection, smallerSequence);
                ArrayList<RubyNode> atLeastAsLargeSequence = new ArrayList<RubyNode>();
                for (int n = 0; n < postArray.size(); ++n) {
                    RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.environment.findLocalVarNode(tempName, this.source, sourceSection), -(postArray.size() - n));
                    atLeastAsLargeSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
                }
                RubyNode atLeastAsLarge = BodyTranslator.sequence(sourceSection, atLeastAsLargeSequence);
                IfElseNode assignPost = new IfElseNode(new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.environment.findLocalVarNode(tempName, this.source, sourceSection)), atLeastAsLarge, smaller);
                sequence.add(assignPost);
            }
            result = new ElidableResultNode(BodyTranslator.sequence(sourceSection, sequence), this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() instanceof StarParseNode) {
            result = rhsTranslated;
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && !(rhs instanceof ArrayParseNode)) {
            SplatCastNode.NilBehavior nilBehavior;
            sequence = new ArrayList();
            if (this.translatingNextExpression) {
                nilBehavior = SplatCastNode.NilBehavior.EMPTY_ARRAY;
            } else if (rhsTranslated instanceof SplatCastNode && ((SplatCastNodeGen)rhsTranslated).getChild() instanceof NilLiteralNode) {
                rhsTranslated = ((SplatCastNodeGen)rhsTranslated).getChild();
                nilBehavior = SplatCastNode.NilBehavior.CONVERT;
            } else {
                nilBehavior = SplatCastNode.NilBehavior.ARRAY_WITH_NIL;
            }
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            SplatCastNode rhsSplatCast = SplatCastNodeGen.create(nilBehavior, true, this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
            rhsSplatCast.unsafeSetSourceSection(sourceSection);
            String tempRHSSplattedName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempSplattedRHS = this.environment.findLocalVarNode(tempRHSSplattedName, this.source, sourceSection).makeWriteNode(rhsSplatCast);
            sequence.add(writeTempSplattedRHS);
            sequence.add(this.translateDummyAssignment(node.getRest(), this.environment.findLocalVarNode(tempRHSSplattedName, this.source, sourceSection)));
            ReadLocalNode assignmentResult = nilBehavior == SplatCastNode.NilBehavior.CONVERT ? this.environment.findLocalVarNode(tempRHSSplattedName, this.source, sourceSection) : this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection);
            result = new ElidableResultNode(BodyTranslator.sequence(sourceSection, sequence), assignmentResult);
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && rhs instanceof ArrayParseNode) {
            result = this.translateDummyAssignment(node.getRest(), rhsTranslated);
        } else if (node.getPre() == null && node.getRest() != null && node.getPost() != null) {
            sequence = new ArrayList();
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            String tempName = this.environment.allocateLocalTemp("array");
            SplatCastNode splatCastNode = SplatCastNodeGen.create(this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
            splatCastNode.unsafeSetSourceSection(sourceSection);
            RubyNode writeTemp = this.environment.findLocalVarNode(tempName, this.source, sourceSection).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            if (node.getRest() != null) {
                ArrayDropTailNode assignedValue = ArrayDropTailNodeGen.create(postArray.size(), this.environment.findLocalVarNode(tempName, this.source, sourceSection));
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            ArrayList<RubyNode> smallerSequence = new ArrayList<RubyNode>();
            for (int n = 0; n < postArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.environment.findLocalVarNode(tempName, this.source, sourceSection), node.getPreCount() + n);
                smallerSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
            }
            RubyNode smaller = BodyTranslator.sequence(sourceSection, smallerSequence);
            ArrayList<RubyNode> atLeastAsLargeSequence = new ArrayList<RubyNode>();
            for (int n = 0; n < postArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.environment.findLocalVarNode(tempName, this.source, sourceSection), -(postArray.size() - n));
                atLeastAsLargeSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
            }
            RubyNode atLeastAsLarge = BodyTranslator.sequence(sourceSection, atLeastAsLargeSequence);
            IfElseNode assignPost = new IfElseNode(new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.environment.findLocalVarNode(tempName, this.source, sourceSection)), atLeastAsLarge, smaller);
            sequence.add(assignPost);
            result = new ElidableResultNode(BodyTranslator.sequence(sourceSection, sequence), this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
        } else {
            throw new UnsupportedOperationException();
        }
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context.getCoreStrings().ASSIGNMENT, result);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitNextNode(NextParseNode node) {
        RubyNode resultNode;
        SourceIndexLength sourceSection = node.getPosition();
        if (!this.environment.isBlock() && !this.translatingWhile) {
            throw new RaiseException(this.context.getCoreExceptions().syntaxError("Invalid next", this.currentNode));
        }
        boolean t = this.translatingNextExpression;
        this.translatingNextExpression = true;
        try {
            resultNode = this.translateNodeOrNil(sourceSection, node.getValueNode());
        }
        finally {
            this.translatingNextExpression = t;
        }
        NextNode ret = new NextNode(resultNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitNilNode(NilParseNode node) {
        if (node instanceof NilImplicitParseNode) {
            NilLiteralNode ret = new NilLiteralNode(true);
            ret.unsafeSetSourceSection(node.getPosition());
            return this.addNewlineIfNeeded(node, ret);
        }
        if (node.getPosition() == null) {
            DeadNode ret = new DeadNode(new Exception());
            return this.addNewlineIfNeeded(node, ret);
        }
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode ret = this.nilNode(this.source, sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitNthRefNode(NthRefParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        this.environment.declareVarInMethodScope("$~");
        GetFromThreadLocalNode readMatchNode = new GetFromThreadLocalNode(this.environment.findLocalVarNode("$~", this.source, sourceSection));
        ReadMatchReferenceNode ret = new ReadMatchReferenceNode(readMatchNode, node.getMatchNumber());
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnAndNode(OpAsgnAndParseNode node) {
        return this.translateOpAsgnAndNode(node, node.getFirstNode().accept(this), node.getSecondNode().accept(this));
    }

    private RubyNode translateOpAsgnAndNode(ParseNode node, RubyNode lhs, RubyNode rhs) {
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        AndNode andNode = new AndNode(lhs, rhs);
        andNode.unsafeSetSourceSection(sourceSection);
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context.getCoreStrings().ASSIGNMENT, andNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnConstDeclNode(OpAsgnConstDeclParseNode node) {
        RubyNode lhs = node.getFirstNode().accept(this);
        RubyNode rhs = node.getSecondNode().accept(this);
        if (!(rhs instanceof WriteConstantNode)) {
            rhs = ((ReadConstantNode)lhs).makeWriteNode(rhs);
        }
        switch (node.getOperator()) {
            case "&&": {
                return this.translateOpAsgnAndNode(node, lhs, rhs);
            }
            case "||": {
                DefinedNode defined = new DefinedNode(lhs);
                lhs = new AndNode(defined, lhs);
                return this.translateOpAsgOrNode(node, lhs, rhs);
            }
        }
        SourceIndexLength sourceSection = node.getPosition();
        RubyCallNodeParameters callParameters = new RubyCallNodeParameters(lhs, node.getOperator(), null, new RubyNode[]{rhs}, false, true);
        RubyNode opNode = this.context.getCoreMethods().createCallNode(this.source, callParameters);
        RubyNode ret = ((ReadConstantNode)lhs).makeWriteNode(opNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnNode(OpAsgnParseNode node) {
        SourceIndexLength pos = node.getPosition();
        boolean isOrOperator = node.getOperatorName().equals("||");
        if (isOrOperator || node.getOperatorName().equals("&&")) {
            String temp = this.environment.allocateLocalTemp("opassign");
            LocalAsgnParseNode writeReceiverToTemp = new LocalAsgnParseNode(pos, temp, 0, node.getReceiverNode());
            LocalVarParseNode readReceiverFromTemp = new LocalVarParseNode(pos, 0, temp);
            CallParseNode readMethod = new CallParseNode(pos, readReceiverFromTemp, node.getVariableName(), null, null);
            CallParseNode writeMethod = new CallParseNode(pos, readReceiverFromTemp, node.getVariableName() + "=", BodyTranslator.buildArrayNode(pos, node.getValueNode(), new ParseNode[0]), null);
            SourceIndexLength sourceSection = pos;
            SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
            RubyNode lhs = ((ParseNode)readMethod).accept(this);
            RubyNode rhs = ((ParseNode)writeMethod).accept(this);
            RubyNode controlNode = isOrOperator ? new OrNode(lhs, rhs) : new AndNode(lhs, rhs);
            DefinedWrapperNode ret = new DefinedWrapperNode(this.context.getCoreStrings().ASSIGNMENT, BodyTranslator.sequence(sourceSection, Arrays.asList(((ParseNode)writeReceiverToTemp).accept(this), controlNode)));
            ret.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, ret);
        }
        String temp = this.environment.allocateLocalTemp("opassign");
        LocalAsgnParseNode writeReceiverToTemp = new LocalAsgnParseNode(pos, temp, 0, node.getReceiverNode());
        LocalVarParseNode readReceiverFromTemp = new LocalVarParseNode(pos, 0, temp);
        CallParseNode readMethod = new CallParseNode(pos, readReceiverFromTemp, node.getVariableName(), null, null);
        CallParseNode operation = new CallParseNode(pos, readMethod, node.getOperatorName(), BodyTranslator.buildArrayNode(pos, node.getValueNode(), new ParseNode[0]), null);
        CallParseNode writeMethod = new CallParseNode(pos, readReceiverFromTemp, node.getVariableName() + "=", BodyTranslator.buildArrayNode(pos, operation, new ParseNode[0]), null);
        BlockParseNode block = new BlockParseNode(pos);
        block.add(writeReceiverToTemp);
        RubyNode writeTemp = ((ParseNode)writeReceiverToTemp).accept(this);
        RubyNode body = ((ParseNode)writeMethod).accept(this);
        SourceIndexLength sourceSection = pos;
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        if (node.isLazy()) {
            ReadLocalNode readLocal = this.environment.findLocalVarNode(temp, this.source, sourceSection);
            body = new IfNode(new NotNode(new IsNilNode(readLocal)), body);
            body.unsafeSetSourceSection(sourceSection);
        }
        RubyNode ret = BodyTranslator.sequence(sourceSection, Arrays.asList(writeTemp, body));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnOrNode(OpAsgnOrParseNode node) {
        RubyNode lhs = node.getFirstNode().accept(this);
        RubyNode rhs = node.getSecondNode().accept(this);
        if (node.getFirstNode().needsDefinitionCheck() && !(node.getFirstNode() instanceof InstVarParseNode)) {
            DefinedNode defined = new DefinedNode(lhs);
            lhs = new AndNode(defined, lhs);
        }
        return this.translateOpAsgOrNode(node, lhs, rhs);
    }

    private RubyNode translateOpAsgOrNode(ParseNode node, RubyNode lhs, RubyNode rhs) {
        SourceIndexLength sourceSection = node.getPosition();
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context.getCoreStrings().ASSIGNMENT, new OrNode(lhs, rhs));
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpElementAsgnNode(OpElementAsgnParseNode node) {
        ParseNode index = node.getArgsNode() == null ? null : node.getArgsNode().childNodes().get(0);
        ParseNode operand = node.getValueNode();
        String temp = this.environment.allocateLocalTemp("opelementassign");
        LocalAsgnParseNode writeArrayToTemp = new LocalAsgnParseNode(node.getPosition(), temp, 0, node.getReceiverNode());
        LocalVarParseNode readArrayFromTemp = new LocalVarParseNode(node.getPosition(), 0, temp);
        CallParseNode arrayRead = new CallParseNode(node.getPosition(), readArrayFromTemp, "[]", BodyTranslator.buildArrayNode(node.getPosition(), index, new ParseNode[0]), null);
        String op = node.getOperatorName();
        ParseNode operation = null;
        operation = op.equals("||") ? new OrParseNode(node.getPosition(), arrayRead, operand) : (op.equals("&&") ? new AndParseNode(node.getPosition(), arrayRead, operand) : new CallParseNode(node.getPosition(), arrayRead, node.getOperatorName(), BodyTranslator.buildArrayNode(node.getPosition(), operand, new ParseNode[0]), null));
        this.copyNewline(node, operation);
        CallParseNode arrayWrite = new CallParseNode(node.getPosition(), readArrayFromTemp, "[]=", BodyTranslator.buildArrayNode(node.getPosition(), index, operation), null);
        BlockParseNode block = new BlockParseNode(node.getPosition());
        block.add(writeArrayToTemp);
        block.add(arrayWrite);
        RubyNode ret = block.accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    private static ArrayParseNode buildArrayNode(SourceIndexLength sourcePosition, ParseNode first, ParseNode ... rest) {
        if (first == null) {
            return new ArrayParseNode(sourcePosition);
        }
        ArrayParseNode array = new ArrayParseNode(sourcePosition, first);
        for (ParseNode node : rest) {
            array.add(node);
        }
        return array;
    }

    @Override
    public RubyNode visitOrNode(OrParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode x = this.translateNodeOrNil(sourceSection, node.getFirstNode());
        RubyNode y = this.translateNodeOrNil(sourceSection, node.getSecondNode());
        OrNode ret = new OrNode(x, y);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitPreExeNode(PreExeParseNode node) {
        RubyNode ret = node.getBodyNode().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitPostExeNode(PostExeParseNode node) {
        StaticScope scope = new StaticScope(StaticScope.Type.BLOCK, null);
        return this.translateCallNode(new CallParseNode(node.getPosition(), new TruffleFragmentParseNode(node.getPosition(), false, new ObjectLiteralNode(this.context.getCoreLibrary().getTruffleKernelModule())), "at_exit", new ListParseNode(node.getPosition(), new TrueParseNode(node.getPosition())), new IterParseNode(node.getPosition(), (ParseNode)node.getArgsNode(), scope, node.getBodyNode())), false, false, false);
    }

    @Override
    public RubyNode visitRationalNode(RationalParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode ret = this.translateRationalComplex(sourceSection, "Rational", new LongFixnumLiteralNode(node.getNumerator()), new LongFixnumLiteralNode(node.getDenominator()));
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode translateRationalComplex(SourceIndexLength sourceSection, String name, RubyNode a, RubyNode b) {
        ObjectLiteralNode moduleNode = new ObjectLiteralNode(this.context.getCoreLibrary().getObjectClass());
        ReadConstantNode receiver = new ReadConstantNode(moduleNode, name);
        RubyNode[] arguments = new RubyNode[]{a, b};
        RubyCallNodeParameters parameters = new RubyCallNodeParameters(receiver, "convert", null, arguments, false, true);
        return BodyTranslator.withSourceSection(sourceSection, new RubyCallNode(parameters));
    }

    @Override
    public RubyNode visitRedoNode(RedoParseNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            throw new RaiseException(this.context.getCoreExceptions().syntaxError("Invalid redo", this.currentNode));
        }
        RedoNode ret = new RedoNode();
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitRegexpNode(RegexpParseNode node) {
        Rope rope = node.getValue().toRope();
        RegexpOptions options = node.getOptions();
        options.setLiteral(true);
        Regex regex = RegexpNodes.compile(this.currentNode, this.context, rope, options);
        Rope updatedRope = (Rope)regex.getUserObject();
        DynamicObject regexp = RegexpNodes.createRubyRegexp(this.context.getCoreLibrary().getRegexpFactory(), regex, updatedRope, options);
        ObjectLiteralNode literalNode = new ObjectLiteralNode(regexp);
        literalNode.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, literalNode);
    }

    public static boolean all7Bit(byte[] bytes) {
        for (int n = 0; n < bytes.length; ++n) {
            if (bytes[n] < 0) {
                return false;
            }
            if (bytes[n] != 92 || n + 1 >= bytes.length || bytes[n + 1] != 120) continue;
            boolean isSecondHex = n + 3 < bytes.length && Character.digit(bytes[n + 3], 16) != -1;
            String num = isSecondHex ? new String(Arrays.copyOfRange(bytes, n + 2, n + 4), StandardCharsets.UTF_8) : new String(Arrays.copyOfRange(bytes, n + 2, n + 3), StandardCharsets.UTF_8);
            int b = Integer.parseInt(num, 16);
            if (b > 127) {
                return false;
            }
            if (isSecondHex) {
                n += 3;
                continue;
            }
            n += 2;
        }
        return true;
    }

    @Override
    public RubyNode visitRescueNode(RescueParseNode node) {
        RescueAnyNode rescueNode;
        RubyNode bodyNode;
        RescueBodyParseNode rescueBody;
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode tryPart = node.getBodyNode() == null || node.getBodyNode().getPosition() == null ? this.nilNode(this.source, sourceSection) : node.getBodyNode().accept(this);
        ArrayList<RescueNode> rescueNodes = new ArrayList<RescueNode>();
        if (this.context.getOptions().BACKTRACES_OMIT_UNUSED && rescueBody != null && rescueBody.getExceptionNodes() == null && rescueBody.getBodyNode() instanceof SideEffectFree && (!(rescueBody.getBodyNode() instanceof GlobalVarParseNode) || !((GlobalVarParseNode)rescueBody.getBodyNode()).getName().equals("$!")) && rescueBody.getOptRescueNode() == null) {
            tryPart = new DisablingBacktracesNode(tryPart);
            bodyNode = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == null ? this.nilNode(this.source, sourceSection) : rescueBody.getBodyNode().accept(this);
            rescueNode = new RescueAnyNode(bodyNode);
            rescueNodes.add(rescueNode);
        } else {
            for (rescueBody = node.getRescueNode(); rescueBody != null; rescueBody = rescueBody.getOptRescueNode()) {
                if (rescueBody.getExceptionNodes() != null) {
                    ArrayDeque<ParseNode> exceptionNodes = new ArrayDeque<ParseNode>();
                    exceptionNodes.push(rescueBody.getExceptionNodes());
                    while (!exceptionNodes.isEmpty()) {
                        RescueNode rescueNode2;
                        ParseNode exceptionNode = (ParseNode)exceptionNodes.pop();
                        if (exceptionNode instanceof ArrayParseNode) {
                            rescueNode2 = this.translateRescueArrayParseNode((ArrayParseNode)exceptionNode, rescueBody, sourceSection, fullSourceSection);
                            rescueNodes.add(rescueNode2);
                            continue;
                        }
                        if (exceptionNode instanceof SplatParseNode) {
                            rescueNode2 = this.translateRescueSplatParseNode((SplatParseNode)exceptionNode, rescueBody, sourceSection, fullSourceSection);
                            rescueNodes.add(rescueNode2);
                            continue;
                        }
                        if (exceptionNode instanceof ArgsCatParseNode) {
                            ArgsCatParseNode argsCat = (ArgsCatParseNode)exceptionNode;
                            exceptionNodes.push(new SplatParseNode(argsCat.getSecondNode().getPosition(), argsCat.getSecondNode()));
                            exceptionNodes.push(argsCat.getFirstNode());
                            continue;
                        }
                        if (exceptionNode instanceof ArgsPushParseNode) {
                            ArgsPushParseNode argsPush = (ArgsPushParseNode)exceptionNode;
                            exceptionNodes.push(new ArrayParseNode(argsPush.getSecondNode().getPosition(), argsPush.getSecondNode()));
                            exceptionNodes.push(argsPush.getFirstNode());
                            continue;
                        }
                        throw new UnsupportedOperationException();
                    }
                    continue;
                }
                bodyNode = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == null ? this.nilNode(this.source, sourceSection) : rescueBody.getBodyNode().accept(this);
                rescueNode = new RescueAnyNode(bodyNode);
                rescueNodes.add(rescueNode);
            }
        }
        RubyNode elsePart = node.getElseNode() == null || node.getElseNode().getPosition() == null ? null : node.getElseNode().accept(this);
        TryNode ret = new TryNode(new ExceptionTranslatingNode(tryPart, UnsupportedOperationBehavior.TYPE_ERROR), rescueNodes.toArray(new RescueNode[rescueNodes.size()]), elsePart);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private RescueNode translateRescueArrayParseNode(ArrayParseNode arrayParse, RescueBodyParseNode rescueBody, SourceIndexLength sourceSection, SourceSection fullSourceSection) {
        ParseNode[] exceptionNodes = arrayParse.children();
        RubyNode[] handlingClasses = new RubyNode[exceptionNodes.length];
        for (int n = 0; n < handlingClasses.length; ++n) {
            handlingClasses[n] = exceptionNodes[n].accept(this);
        }
        RubyNode translatedBody = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == null ? this.nilNode(this.source, sourceSection) : rescueBody.getBodyNode().accept(this);
        return BodyTranslator.withSourceSection(sourceSection, new RescueClassesNode(handlingClasses, translatedBody));
    }

    private RescueNode translateRescueSplatParseNode(SplatParseNode splat, RescueBodyParseNode rescueBody, SourceIndexLength sourceSection, SourceSection fullSourceSection) {
        RubyNode splatTranslated = this.translateNodeOrNil(sourceSection, splat.getValue());
        RubyNode rescueBodyTranslated = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == null ? this.nilNode(this.source, sourceSection) : rescueBody.getBodyNode().accept(this);
        return BodyTranslator.withSourceSection(sourceSection, new RescueSplatNode(splatTranslated, rescueBodyTranslated));
    }

    @Override
    public RubyNode visitRetryNode(RetryParseNode node) {
        RetryNode ret = new RetryNode();
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitReturnNode(ReturnParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode translatedChild = this.translateNodeOrNil(sourceSection, node.getValueNode());
        ReturnNode ret = new ReturnNode(this.environment.getReturnID(), translatedChild);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitSClassNode(SClassParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode receiverNode = node.getReceiverNode().accept(this);
        SingletonClassNode singletonClassNode = SingletonClassNodeGen.create(receiverNode);
        boolean dynamicConstantLookup = this.environment.getParseEnvironment().isDynamicConstantLookup();
        if (!(dynamicConstantLookup || this.environment.isModuleBody() && node.getReceiverNode() instanceof SelfParseNode || this.environment.parent == null && this.environment.isModuleBody())) {
            this.environment.getParseEnvironment().setDynamicConstantLookup(true);
            if (this.context.getOptions().LOG_DYNAMIC_CONSTANT_LOOKUP) {
                Log.LOGGER.info(() -> "start dynamic constant lookup at " + RubyLanguage.fileLine(fullSourceSection));
            }
        }
        try {
            ret = this.openModule(sourceSection, singletonClassNode, "(singleton-def)", node.getBodyNode(), true);
        }
        finally {
            this.environment.getParseEnvironment().setDynamicConstantLookup(dynamicConstantLookup);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSValueNode(SValueParseNode node) {
        RubyNode ret = node.getValue().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSelfNode(SelfParseNode node) {
        SelfNode ret = new SelfNode(this.environment.getFrameDescriptor());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSplatNode(SplatParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode value = this.translateNodeOrNil(sourceSection, node.getValue());
        SplatCastNode ret = SplatCastNodeGen.create(SplatCastNode.NilBehavior.CONVERT, false, value);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitStrNode(StrParseNode node) {
        RubyNode ret;
        SourceIndexLength sourceSection = node.getPosition();
        ParserByteList byteList = node.getValue();
        CodeRange codeRange = node.getCodeRange();
        Rope rope = this.context.getRopeTable().getRope(byteList, codeRange);
        if (node.isFrozen() && !this.getSourcePath(sourceSection).startsWith(this.context.getCoreLibrary().getCoreLoadPath() + "/core/")) {
            DynamicObject frozenString = this.context.getFrozenStrings().getFrozenString(rope);
            ret = new DefinedWrapperNode(this.context.getCoreStrings().METHOD, new ObjectLiteralNode(frozenString));
        } else {
            ret = new StringLiteralNode(rope);
        }
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSymbolNode(SymbolParseNode node) {
        String name = node.getName();
        byte[] bytes = new byte[name.length()];
        for (int i = 0; i < name.length(); ++i) {
            char val = name.charAt(i);
            assert (val >= '\u0000' && val < '\u0100');
            bytes[i] = (byte)(val & 0xFF);
        }
        LeafRope rope = RopeOperations.create(bytes, node.getEncoding(), CodeRange.CR_UNKNOWN);
        ObjectLiteralNode ret = new ObjectLiteralNode(this.context.getSymbolTable().getSymbol(rope));
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitTrueNode(TrueParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        BooleanLiteralNode ret = new BooleanLiteralNode(true);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitUndefNode(UndefParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        DynamicObject nameSymbol = this.translateNameNodeToSymbol(node.getName());
        ModuleNodes.UndefMethodNode ret = ModuleNodesFactory.UndefMethodNodeFactory.create(new RubyNode[]{new RaiseIfFrozenNode(new GetDefaultDefineeNode()), new ObjectLiteralNode(new Object[]{nameSymbol})});
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitUntilNode(UntilParseNode node) {
        WhileParseNode whileNode = new WhileParseNode(node.getPosition(), node.getConditionNode(), node.getBodyNode(), node.evaluateAtStart());
        this.copyNewline(node, whileNode);
        RubyNode ret = this.translateWhileNode(whileNode, true);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitVCallNode(VCallParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        if (node.getName().equals("undefined") && this.getSourcePath(sourceSection).startsWith(this.corePath())) {
            ObjectLiteralNode ret = new ObjectLiteralNode(NotProvided.INSTANCE);
            ret.unsafeSetSourceSection(node.getPosition());
            return this.addNewlineIfNeeded(node, ret);
        }
        SelfParseNode receiver = new SelfParseNode(node.getPosition());
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, node.getName(), null, null);
        this.copyNewline(node, callNode);
        RubyNode ret = this.translateCallNode(callNode, true, true, false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitWhileNode(WhileParseNode node) {
        RubyNode ret = this.translateWhileNode(node, false);
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateWhileNode(WhileParseNode node, boolean conditionInversed) {
        RubyNode body;
        SourceIndexLength sourceSection = node.getPosition();
        RubyNode condition = node.getConditionNode().accept(this);
        if (conditionInversed) {
            condition = new NotNode(condition);
        }
        BreakID whileBreakID = this.environment.getParseEnvironment().allocateBreakID();
        boolean oldTranslatingWhile = this.translatingWhile;
        this.translatingWhile = true;
        BreakID oldBreakID = this.environment.getBreakID();
        this.environment.setBreakIDForWhile(whileBreakID);
        this.frameOnStackMarkerSlotStack.push(BAD_FRAME_SLOT);
        try {
            body = this.translateNodeOrNil(sourceSection, node.getBodyNode());
        }
        finally {
            this.frameOnStackMarkerSlotStack.pop();
            this.environment.setBreakIDForWhile(oldBreakID);
            this.translatingWhile = oldTranslatingWhile;
        }
        WhileNode loop = node.evaluateAtStart() ? new WhileNode(new WhileNode.WhileRepeatingNode(this.context, condition, body)) : new WhileNode(new WhileNode.DoWhileRepeatingNode(this.context, condition, body));
        CatchBreakNode ret = new CatchBreakNode(whileBreakID, loop);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitXStrNode(XStrParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), new StrParseNode(node.getPosition(), node.getValue()), new ParseNode[0]);
        FCallParseNode callNode = new FCallParseNode(node.getPosition(), "`", argsNode, null);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitYieldNode(YieldParseNode node) {
        boolean unsplat;
        ArrayList<ParseNode> arguments = new ArrayList<ParseNode>();
        ParseNode argsNode = node.getArgsNode();
        boolean bl = unsplat = argsNode instanceof SplatParseNode || argsNode instanceof ArgsCatParseNode;
        if (argsNode instanceof SplatParseNode) {
            argsNode = ((SplatParseNode)argsNode).getValue();
        }
        if (argsNode != null) {
            if (argsNode instanceof ListParseNode) {
                arguments.addAll(node.getArgsNode().childNodes());
            } else {
                arguments.add(node.getArgsNode());
            }
        }
        ArrayList<RubyNode> argumentsTranslated = new ArrayList<RubyNode>();
        for (ParseNode argument : arguments) {
            argumentsTranslated.add(argument.accept(this));
        }
        RubyNode[] argumentsTranslatedArray = argumentsTranslated.toArray(new RubyNode[argumentsTranslated.size()]);
        YieldExpressionNode ret = new YieldExpressionNode(unsplat, argumentsTranslatedArray);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitZArrayNode(ZArrayParseNode node) {
        RubyNode[] values = new RubyNode[]{};
        ArrayLiteralNode ret = ArrayLiteralNode.create(values);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBackRefNode(BackRefParseNode node) {
        int index = 0;
        switch (node.getType()) {
            case '`': {
                index = -1;
                break;
            }
            case '\'': {
                index = -2;
                break;
            }
            case '&': {
                index = -3;
                break;
            }
            case '+': {
                index = -4;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Character.toString(node.getType()));
            }
        }
        SourceIndexLength sourceSection = node.getPosition();
        this.environment.declareVarInMethodScope("$~");
        GetFromThreadLocalNode readMatchNode = new GetFromThreadLocalNode(this.environment.findLocalVarNode("$~", this.source, sourceSection));
        ReadMatchReferenceNode ret = new ReadMatchReferenceNode(readMatchNode, index);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitStarNode(StarParseNode star) {
        return this.nilNode(this.source, star.getPosition());
    }

    protected RubyNode initFlipFlopStates(SourceIndexLength sourceSection) {
        RubyNode[] initNodes = new RubyNode[this.environment.getFlipFlopStates().size()];
        for (int n = 0; n < initNodes.length; ++n) {
            initNodes[n] = new InitFlipFlopSlotNode(this.environment.getFlipFlopStates().get(n));
        }
        return BodyTranslator.sequence(sourceSection, Arrays.asList(initNodes));
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        throw new UnsupportedOperationException(node.toString() + " " + node.getPosition());
    }

    public TranslatorEnvironment getEnvironment() {
        return this.environment;
    }

    protected String getIdentifierInNewEnvironment(boolean isBlock, String namedMethodName) {
        if (isBlock) {
            TranslatorEnvironment methodParent = this.environment;
            while (methodParent.isBlock()) {
                methodParent = methodParent.getParent();
            }
            if (this.environment.getBlockDepth() + 1 > 1) {
                return StringUtils.format("block (%d levels) in %s", this.environment.getBlockDepth() + 1, methodParent.getNamedMethodName());
            }
            return StringUtils.format("block in %s", methodParent.getNamedMethodName());
        }
        return namedMethodName;
    }

    @Override
    public RubyNode visitTruffleFragmentNode(TruffleFragmentParseNode node) {
        return this.addNewlineIfNeeded(node, node.getFragment());
    }

    @Override
    public RubyNode visitOther(ParseNode node) {
        if (node instanceof ReadLocalDummyParseNode) {
            ReadLocalDummyParseNode readLocal = (ReadLocalDummyParseNode)node;
            ReadLocalVariableNode ret = new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, readLocal.getFrameSlot());
            ret.unsafeSetSourceSection(readLocal.getPosition());
            return this.addNewlineIfNeeded(node, ret);
        }
        throw new UnsupportedOperationException();
    }

    private void copyNewline(ParseNode from, ParseNode to) {
        if (from.isNewline()) {
            to.setNewline();
        }
    }

    private RubyNode addNewlineIfNeeded(ParseNode jrubyNode, RubyNode node) {
        if (jrubyNode.isNewline()) {
            SourceIndexLength current = node.getEncapsulatingSourceIndexLength();
            if (current == null) {
                return node;
            }
            if (this.context.getCoverageManager().isEnabled()) {
                node.unsafeSetIsCoverageLine();
                this.context.getCoverageManager().setLineHasCode(this.source, current.toSourceSection(this.source).getStartLine());
            }
            node.unsafeSetIsNewLine();
        }
        return node;
    }

    protected static class ArgumentsAndBlockTranslation {
        private final RubyNode block;
        private final RubyNode[] arguments;
        private final boolean isSplatted;
        private final FrameSlot frameOnStackMarkerSlot;

        public ArgumentsAndBlockTranslation(RubyNode block, RubyNode[] arguments, boolean isSplatted, FrameSlot frameOnStackMarkerSlot) {
            this.block = block;
            this.arguments = arguments;
            this.isSplatted = isSplatted;
            this.frameOnStackMarkerSlot = frameOnStackMarkerSlot;
        }

        public RubyNode getBlock() {
            return this.block;
        }

        public RubyNode[] getArguments() {
            return this.arguments;
        }

        public boolean isSplatted() {
            return this.isSplatted;
        }

        public FrameSlot getFrameOnStackMarkerSlot() {
            return this.frameOnStackMarkerSlot;
        }
    }
}

