/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.array.ArrayToObjectArrayNode;
import org.jruby.truffle.core.array.ArrayToObjectArrayNodeGen;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

public class ReadZSuperArgumentsNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] reloadNodes;
    @Node.Child
    private ArrayToObjectArrayNode unsplatNode;
    private final int restArgIndex;

    public ReadZSuperArgumentsNode(int restArgIndex, RubyNode[] reloadNodes) {
        this.restArgIndex = restArgIndex;
        this.reloadNodes = reloadNodes;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        CompilerAsserts.compilationConstant((Object)this.reloadNodes.length);
        Object[] superArguments = new Object[this.reloadNodes.length];
        for (int n = 0; n < superArguments.length; ++n) {
            superArguments[n] = this.reloadNodes[n].execute(frame);
        }
        if (this.restArgIndex != -1) {
            Object restArg = superArguments[this.restArgIndex];
            assert (RubyGuards.isRubyArray(restArg));
            Object[] restArgs = this.unsplat((DynamicObject)restArg);
            int after = superArguments.length - (this.restArgIndex + 1);
            Object[] splattedArguments = ArrayUtils.copyOf(superArguments, superArguments.length + restArgs.length - 1);
            ArrayUtils.arraycopy(superArguments, this.restArgIndex + 1, splattedArguments, this.restArgIndex + restArgs.length, after);
            ArrayUtils.arraycopy(restArgs, 0, splattedArguments, this.restArgIndex, restArgs.length);
            superArguments = splattedArguments;
        }
        return superArguments;
    }

    private Object[] unsplat(DynamicObject array) {
        if (this.unsplatNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.unsplatNode = (ArrayToObjectArrayNode)this.insert(ArrayToObjectArrayNodeGen.create(null));
        }
        return this.unsplatNode.executeToObjectArray(array);
    }
}

