/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.core.array.ArrayToObjectArrayNode;
import org.jruby.truffle.core.array.ArrayToObjectArrayNodeGen;
import org.jruby.truffle.language.RubyNode;

public class ReadSuperArgumentsNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] arguments;
    @Node.Child
    private ArrayToObjectArrayNode unsplatNode;
    private final boolean isSplatted;

    public ReadSuperArgumentsNode(RubyNode[] arguments, boolean isSplatted) {
        assert (!isSplatted || arguments.length == 1);
        this.arguments = arguments;
        this.isSplatted = isSplatted;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        CompilerAsserts.compilationConstant((Object)this.arguments.length);
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        if (this.isSplatted) {
            return this.unsplat(argumentsObjects);
        }
        return argumentsObjects;
    }

    private Object[] unsplat(Object[] argumentsObjects) {
        if (this.unsplatNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.unsplatNode = (ArrayToObjectArrayNode)this.insert(ArrayToObjectArrayNodeGen.create(null));
        }
        return this.unsplatNode.unsplat(argumentsObjects);
    }
}

