/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.supercall;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.MetaClassNode;
import org.jruby.truffle.language.objects.MetaClassNodeGen;

@NodeChild(value="self")
public abstract class LookupSuperMethodNode
extends RubyNode {
    @Node.Child
    private MetaClassNode metaClassNode = MetaClassNodeGen.create(null);

    public abstract InternalMethod executeLookupSuperMethod(VirtualFrame var1, Object var2);

    @Specialization(guards={"getCurrentMethod(frame) == currentMethod", "metaClass(self) == selfMetaClass"}, assumptions={"getUnmodifiedAssumption(selfMetaClass)"}, limit="getCacheLimit()")
    protected InternalMethod lookupSuperMethodCachedDynamicObject(VirtualFrame frame, DynamicObject self, @Cached(value="getCurrentMethod(frame)") InternalMethod currentMethod, @Cached(value="metaClass(self)") DynamicObject selfMetaClass, @Cached(value="doLookup(currentMethod, selfMetaClass)") InternalMethod superMethod) {
        return superMethod;
    }

    @Specialization
    protected InternalMethod lookupSuperMethodUncached(VirtualFrame frame, Object self) {
        InternalMethod currentMethod = this.getCurrentMethod(frame);
        DynamicObject selfMetaClass = this.metaClass(self);
        return this.doLookup(currentMethod, selfMetaClass);
    }

    public Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    protected InternalMethod getCurrentMethod(VirtualFrame frame) {
        return RubyArguments.getMethod((Frame)frame);
    }

    protected DynamicObject metaClass(Object object) {
        return this.metaClassNode.executeMetaClass(object);
    }

    @CompilerDirectives.TruffleBoundary
    protected InternalMethod doLookup(InternalMethod currentMethod, DynamicObject selfMetaClass) {
        assert (RubyGuards.isRubyClass(selfMetaClass));
        InternalMethod superMethod = ModuleOperations.lookupSuperMethod(currentMethod, selfMetaClass);
        if (superMethod != null && superMethod.isUndefined()) {
            superMethod = null;
        }
        return superMethod;
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().METHOD_LOOKUP_CACHE;
    }
}

