/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects.shared;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.language.objects.ObjectGraph;
import org.jruby.truffle.options.OptionsBuilder;
import org.jruby.truffle.options.OptionsCatalog;

public class SharedObjects {
    public static final boolean ENABLED = (Boolean)OptionsBuilder.readSystemProperty(OptionsCatalog.SHARED_OBJECTS_ENABLED);
    public static final boolean SHARE_ALL = (Boolean)OptionsBuilder.readSystemProperty(OptionsCatalog.SHARED_OBJECTS_SHARE_ALL);
    public static final boolean DEBUG = (Boolean)OptionsBuilder.readSystemProperty(OptionsCatalog.SHARED_OBJECTS_DEBUG);
    private final RubyContext context;
    private boolean sharing = false;

    public SharedObjects(RubyContext context) {
        this.context = context;
    }

    public boolean isSharing() {
        return this.sharing;
    }

    public void startSharing() {
        this.sharing = true;
        SharedObjects.shareContextRoots(this.context);
    }

    private static void shareContextRoots(RubyContext context) {
        ArrayDeque<DynamicObject> stack = new ArrayDeque<DynamicObject>();
        for (DynamicObject object : context.getCoreLibrary().getGlobalVariables().dynamicObjectValues()) {
            stack.push(object);
        }
        stack.push(context.getCoreLibrary().getObjectClass());
        for (DynamicObject thread : context.getThreadManager().iterateThreads()) {
            stack.push(thread);
        }
        long t0 = System.currentTimeMillis();
        SharedObjects.shareObjects(stack);
        if (context.getOptions().SHARED_OBJECTS_DEBUG) {
            System.err.println("Sharing roots took " + (System.currentTimeMillis() - t0) + " ms");
        }
    }

    public static void shareDeclarationFrame(DynamicObject block) {
        ArrayDeque<DynamicObject> stack = new ArrayDeque<DynamicObject>();
        if (DEBUG) {
            SourceSection sourceSection = Layouts.PROC.getSharedMethodInfo(block).getSourceSection();
            System.err.println("Sharing decl frame of " + RubyLanguage.fileLine(sourceSection));
        }
        MaterializedFrame declarationFrame = Layouts.PROC.getDeclarationFrame(block);
        stack.addAll(ObjectGraph.getObjectsInFrame((Frame)declarationFrame));
        SharedObjects.shareObjects(stack);
    }

    private static void shareObjects(Deque<DynamicObject> stack) {
        while (!stack.isEmpty()) {
            DynamicObject object = stack.pop();
            if (!SharedObjects.share(object)) continue;
            stack.addAll(ObjectGraph.getAdjacentObjects(object));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void shareObject(Object value) {
        ArrayDeque<DynamicObject> stack = new ArrayDeque<DynamicObject>();
        stack.add((DynamicObject)value);
        SharedObjects.shareObjects(stack);
    }

    public static boolean isShared(DynamicObject object) {
        return SharedObjects.isShared(object.getShape());
    }

    public static boolean isShared(Shape shape) {
        return ENABLED && (SHARE_ALL || shape.isShared());
    }

    public static void writeBarrier(Object value) {
        if (ENABLED && value instanceof DynamicObject && !SharedObjects.isShared((DynamicObject)value)) {
            SharedObjects.shareObject(value);
        }
    }

    public static void propagate(DynamicObject source, Object value) {
        if (SharedObjects.isShared(source)) {
            SharedObjects.writeBarrier(value);
        }
    }

    private static boolean share(DynamicObject object) {
        if (SharedObjects.isShared(object)) {
            return false;
        }
        object.updateShape();
        Shape oldShape = object.getShape();
        Shape newShape = oldShape.makeSharedShape();
        object.setShapeAndGrow(oldShape, newShape);
        return true;
    }
}

