/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects.shared;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.language.objects.ShapeCachingGuards;
import org.jruby.truffle.language.objects.shared.SharedObjects;

@ImportStatic(value={ShapeCachingGuards.class})
public abstract class IsSharedNode
extends Node {
    protected static final int CACHE_LIMIT = 8;

    public abstract boolean executeIsShared(DynamicObject var1);

    @Specialization(guards={"object.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    protected boolean isShareCached(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="isShared(cachedShape)") boolean shared) {
        return shared;
    }

    @Specialization(guards={"updateShape(object)"})
    public boolean updateShapeAndIsShared(DynamicObject object) {
        return this.executeIsShared(object);
    }

    @Specialization(contains={"isShareCached", "updateShapeAndIsShared"})
    protected boolean isSharedUncached(DynamicObject object) {
        return SharedObjects.isShared(object);
    }

    protected boolean isShared(Shape shape) {
        return SharedObjects.isShared(shape);
    }
}

