/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.objects.PropertyFlags;
import org.jruby.truffle.language.objects.ShapeCachingGuards;
import org.jruby.truffle.language.objects.shared.SharedObjects;
import org.jruby.truffle.language.objects.shared.WriteBarrierNode;

@ImportStatic(value={RubyGuards.class, ShapeCachingGuards.class})
public abstract class WriteObjectFieldNode
extends RubyBaseNode {
    private final Object name;

    public WriteObjectFieldNode(Object name) {
        this.name = name;
    }

    public Object getName() {
        return this.name;
    }

    public abstract void execute(DynamicObject var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"location != null", "object.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()", "validLocation"}, limit="getCacheLimit()")
    public void writeExistingField(DynamicObject object, Object value, @Cached(value="getLocation(object, value)") Location location, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="createAssumption()") Assumption validLocation, @Cached(value="isShared(cachedShape)") boolean shared, @Cached(value="createWriteBarrierNode(shared)") WriteBarrierNode writeBarrierNode) {
        block7: {
            try {
                if (shared) {
                    writeBarrierNode.executeWriteBarrier(value);
                    DynamicObject dynamicObject = object;
                    synchronized (dynamicObject) {
                        if (object.getShape() != cachedShape) {
                            CompilerDirectives.transferToInterpreter();
                            this.execute(object, value);
                            return;
                        }
                        location.set(object, value, cachedShape);
                        break block7;
                    }
                }
                location.set(object, value, cachedShape);
            }
            catch (FinalLocationException | IncompatibleLocationException e) {
                validLocation.invalidate();
                this.execute(object, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"location == null", "object.getShape() == oldShape"}, assumptions={"oldShape.getValidAssumption()", "newShape.getValidAssumption()", "validLocation"}, limit="getCacheLimit()")
    public void writeNewField(DynamicObject object, Object value, @Cached(value="getLocation(object, value)") Location location, @Cached(value="object.getShape()") Shape oldShape, @Cached(value="defineProperty(oldShape, value)") Shape newShape, @Cached(value="getNewLocation(newShape)") Location newLocation, @Cached(value="createAssumption()") Assumption validLocation, @Cached(value="isShared(oldShape)") boolean shared, @Cached(value="createWriteBarrierNode(shared)") WriteBarrierNode writeBarrierNode) {
        block7: {
            try {
                if (shared) {
                    writeBarrierNode.executeWriteBarrier(value);
                    DynamicObject dynamicObject = object;
                    synchronized (dynamicObject) {
                        if (object.getShape() != oldShape) {
                            CompilerDirectives.transferToInterpreter();
                            this.execute(object, value);
                            return;
                        }
                        newLocation.set(object, value, oldShape, newShape);
                        break block7;
                    }
                }
                newLocation.set(object, value, oldShape, newShape);
            }
            catch (IncompatibleLocationException e) {
                validLocation.invalidate();
                newShape.getLastProperty().setGeneric(object, value, oldShape, newShape);
            }
        }
    }

    @Specialization(guards={"updateShape(object)"})
    public void updateShapeAndWrite(DynamicObject object, Object value) {
        this.execute(object, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"writeExistingField", "writeNewField", "updateShapeAndWrite"})
    public void writeUncached(DynamicObject object, Object value) {
        boolean shared = SharedObjects.isShared(object);
        if (shared) {
            SharedObjects.writeBarrier(value);
            DynamicObject dynamicObject = object;
            synchronized (dynamicObject) {
                Shape shape = object.getShape();
                Shape newShape = this.defineProperty(shape, value);
                newShape.getProperty(this.name).setSafe(object, value, shape, newShape);
            }
        } else {
            object.define(this.name, value, 0);
        }
    }

    protected Location getLocation(DynamicObject object, Object value) {
        Shape oldShape = object.getShape();
        Property property = oldShape.getProperty(this.name);
        if (PropertyFlags.isDefined(property) && property.getLocation().canSet(object, value)) {
            return property.getLocation();
        }
        return null;
    }

    protected Shape defineProperty(Shape oldShape, Object value) {
        Property property = oldShape.getProperty(this.name);
        if (property != null && PropertyFlags.isRemoved(property)) {
            Location location = oldShape.allocator().locationForValue(value);
            return oldShape.replaceProperty(property, property.relocate(location).copyWithFlags(0));
        }
        return oldShape.defineProperty(this.name, value, 0);
    }

    protected Location getNewLocation(Shape newShape) {
        return newShape.getProperty(this.name).getLocation();
    }

    protected Assumption createAssumption() {
        return Truffle.getRuntime().createAssumption("object location is valid");
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().INSTANCE_VARIABLE_CACHE;
    }

    protected boolean isShared(Shape shape) {
        return SharedObjects.isShared(shape);
    }

    protected WriteBarrierNode createWriteBarrierNode(boolean shared) {
        if (shared) {
            return WriteBarrierNode.create();
        }
        return null;
    }

    public String toString() {
        return this.name + " =";
    }
}

