/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadFrameSlotNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.parser.ReadLocalNode;

public class ReadLocalVariableNode
extends ReadLocalNode {
    private final LocalVariableType type;
    private final FrameSlot frameSlot;
    @Node.Child
    private ReadFrameSlotNode readFrameSlotNode;

    public ReadLocalVariableNode(LocalVariableType type, FrameSlot frameSlot) {
        this.type = type;
        this.frameSlot = frameSlot;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.checkReadFrameSlotNode();
        return this.readFrameSlotNode.executeRead((Frame)frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        switch (this.type) {
            case FRAME_LOCAL: {
                return this.coreStrings().LOCAL_VARIABLE.createInstance();
            }
            case FRAME_LOCAL_GLOBAL: {
                this.checkReadFrameSlotNode();
                if (this.readFrameSlotNode.executeRead((Frame)frame) != this.nil()) {
                    return this.coreStrings().GLOBAL_VARIABLE.createInstance();
                }
                return this.nil();
            }
            case ALWAYS_DEFINED_GLOBAL: {
                return this.coreStrings().GLOBAL_VARIABLE.createInstance();
            }
        }
        throw new UnsupportedOperationException("didn't expect local type " + (Object)((Object)this.type));
    }

    private void checkReadFrameSlotNode() {
        if (this.readFrameSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readFrameSlotNode = (ReadFrameSlotNode)this.insert(ReadFrameSlotNodeGen.create(this.frameSlot));
        }
    }

    @Override
    public RubyNode makeWriteNode(RubyNode rhs) {
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.getContext(), this.frameSlot, rhs);
    }
}

