/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.GetConstantNode;
import org.jruby.truffle.language.constants.LookupConstantNode;
import org.jruby.truffle.language.constants.LookupConstantNodeGen;
import org.jruby.truffle.language.constants.WriteConstantNode;
import org.jruby.truffle.language.control.RaiseException;

public class ReadConstantNode
extends RubyNode {
    private final String name;
    @Node.Child
    private RubyNode moduleNode;
    @Node.Child
    private LookupConstantNode lookupConstantNode = LookupConstantNodeGen.create(false, false);
    @Node.Child
    private GetConstantNode getConstantNode = GetConstantNode.create();

    public ReadConstantNode(RubyNode moduleNode, String name) {
        this.name = name;
        this.moduleNode = moduleNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object module = this.moduleNode.execute(frame);
        RubyConstant constant = this.lookupConstantNode.lookupConstant(frame, module, this.name);
        return this.getConstantNode.executeGetConstant(frame, module, this.name, constant, this.lookupConstantNode);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        RubyConstant constant;
        Object isModuleDefined = this.moduleNode.isDefined(frame);
        if (isModuleDefined == this.nil()) {
            return this.nil();
        }
        Object module = this.moduleNode.execute(frame);
        if (!RubyGuards.isRubyModule(module)) {
            return this.nil();
        }
        try {
            constant = this.lookupConstantNode.lookupConstant(frame, module, this.name);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        if (constant == null) {
            return this.nil();
        }
        return this.create7BitString("constant", (Encoding)UTF8Encoding.INSTANCE);
    }

    public RubyNode makeWriteNode(RubyNode rhs) {
        return new WriteConstantNode(this.name, (RubyNode)NodeUtil.cloneNode((Node)this.moduleNode), rhs);
    }
}

