/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.RubyArguments;

public class ReadPreArgumentNode
extends RubyNode {
    private final int index;
    private final BranchProfile outOfRangeProfile = BranchProfile.create();
    private final MissingArgumentBehavior missingArgumentBehavior;

    public ReadPreArgumentNode(int index, MissingArgumentBehavior missingArgumentBehavior) {
        this.index = index;
        this.missingArgumentBehavior = missingArgumentBehavior;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.index < RubyArguments.getArgumentsCount((Frame)frame)) {
            return RubyArguments.getArgument((Frame)frame, this.index);
        }
        this.outOfRangeProfile.enter();
        switch (this.missingArgumentBehavior) {
            case RUNTIME_ERROR: {
                throw new IndexOutOfBoundsException();
            }
            case UNDEFINED: {
                return NotProvided.INSTANCE;
            }
            case NIL: {
                return this.nil();
            }
        }
        throw new UnsupportedOperationException("unknown missing argument behaviour");
    }
}

