/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.Visibility;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.backtrace.InternalRootNode;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.shared.SharedObjects;
import org.jruby.truffle.parser.ParserContext;
import org.jruby.truffle.parser.TranslatorDriver;

public class LazyRubyRootNode
extends RootNode
implements InternalRootNode {
    private final Source source;
    private final String[] argumentNames;
    @Node.Child
    private Node findContextNode = RubyLanguage.INSTANCE.unprotectedCreateFindContextNode();
    @CompilerDirectives.CompilationFinal
    private RubyContext cachedContext;
    @CompilerDirectives.CompilationFinal
    private DynamicObject mainObject;
    @CompilerDirectives.CompilationFinal
    private InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;

    public LazyRubyRootNode(SourceSection sourceSection, FrameDescriptor frameDescriptor, Source source, String[] argumentNames) {
        super(RubyLanguage.class, sourceSection, frameDescriptor);
        this.source = source;
        this.argumentNames = argumentNames;
    }

    public Object execute(VirtualFrame frame) {
        RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
        if (this.cachedContext == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cachedContext = context;
        }
        if (this.callNode == null || context != this.cachedContext) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            TranslatorDriver translator = new TranslatorDriver(context);
            ParserContext parserContext = this.source.getName().equals("main") && this.source.isInternal() ? ParserContext.TOP_LEVEL_FIRST : ParserContext.TOP_LEVEL;
            RubyRootNode rootNode = translator.parse(context, this.source, (Encoding)UTF8Encoding.INSTANCE, parserContext, this.argumentNames, null, null, true, null);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            this.callNode = (DirectCallNode)this.insert((Node)Truffle.getRuntime().createDirectCallNode((CallTarget)callTarget));
            this.callNode.forceInlining();
            this.mainObject = context.getCoreLibrary().getMainObject();
            this.method = new InternalMethod(context, rootNode.getSharedMethodInfo(), rootNode.getSharedMethodInfo().getLexicalScope(), rootNode.getSharedMethodInfo().getName(), context.getCoreLibrary().getObjectClass(), Visibility.PUBLIC, (CallTarget)callTarget);
        }
        Object[] arguments = RubyArguments.pack(null, null, this.method, DeclarationContext.TOP_LEVEL, null, this.mainObject, null, frame.getArguments());
        Object value = this.callNode.call(frame, arguments);
        if (SharedObjects.ENABLED) {
            SharedObjects.writeBarrier(value);
        }
        return value;
    }
}

