/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.List;
import org.jruby.truffle.interop.ForeignExecuteNodeSubNodeGen;
import org.jruby.truffle.interop.RubyMessageResolution;

public abstract class ForeignExecuteNodeSub
extends RubyMessageResolution.ForeignExecuteNode {
    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, DynamicObject object, Object[] arguments) {
        return this.access(frame, object, arguments);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new EXECUTERootNode(language);
    }

    private static final class EXECUTERootNode
    extends RootNode {
        @Node.Child
        private ForeignExecuteNodeSub node = ForeignExecuteNodeSubNodeGen.create();

        protected EXECUTERootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        public Object execute(VirtualFrame frame) {
            try {
                TruffleObject receiver = ForeignAccess.getReceiver((Frame)frame);
                List arguments = ForeignAccess.getArguments((Frame)frame);
                Object[] args = new Object[arguments.size()];
                for (int i = 0; i < arguments.size(); ++i) {
                    args[i] = arguments.get(i);
                }
                return this.node.executeWithTarget(frame, receiver, args);
            }
            catch (UnsupportedSpecializationException e) {
                if (e.getNode() instanceof ForeignExecuteNodeSub) {
                    throw UnsupportedTypeException.raise((Exception)((Object)e), (Object[])e.getSuppliedValues());
                }
                throw e;
            }
        }
    }
}

