/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.time;

import com.oracle.truffle.api.nodes.Node;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormatSymbols;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.encoding.EncodingManager;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.time.RubyTimeOutputFormatter;
import org.jruby.truffle.core.time.StrftimeLexer;
import org.jruby.truffle.debug.DebugHelpers;
import org.jruby.truffle.language.control.RaiseException;

public class RubyDateFormatter {
    private static final DateFormatSymbols FORMAT_SYMBOLS = new DateFormatSymbols(Locale.US);
    private static final Token[] CONVERSION2TOKEN = new Token[256];
    private RubyContext context;
    private Node currentNode;
    private StrftimeLexer lexer;
    private static final Map<String, String> SHORT_STD_TZNAME = RubyDateFormatter.map("Etc/UCT", "UCT", "MET", "MET", "UCT", "UCT");
    private static final Map<String, String> SHORT_DL_TZNAME = RubyDateFormatter.map("Etc/UCT", "UCT", "MET", "MEST", "UCT", "UCT");
    private static final Pattern TIME_OFFSET_PATTERN = Pattern.compile("([\\+-])(\\d\\d):(\\d\\d)(?::(\\d\\d))?");

    public RubyDateFormatter(RubyContext context, Node currentNode) {
        this.context = context;
        this.currentNode = currentNode;
        this.lexer = new StrftimeLexer((Reader)null);
    }

    private void addToPattern(List<Token> compiledPattern, String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                compiledPattern.add(Token.format(c));
                continue;
            }
            compiledPattern.add(Token.str(Character.toString(c)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Token> compilePattern(Rope pattern, boolean dateLibrary) {
        LinkedList<Token> compiledPattern = new LinkedList<Token>();
        Encoding enc = pattern.getEncoding();
        if (!enc.isAsciiCompatible()) {
            throw new RaiseException(this.context.getCoreExceptions().argumentError("format should have ASCII compatible encoding", this.currentNode));
        }
        if (enc != ASCIIEncoding.INSTANCE) {
            compiledPattern.add(new Token(Format.FORMAT_ENCODING, enc));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(pattern.getBytes(), 0, pattern.byteLength());
        InputStreamReader reader = new InputStreamReader((InputStream)in, EncodingManager.charsetForEncoding(pattern.getEncoding()));
        this.lexer.yyreset(reader);
        try {
            char c;
            Token token;
            block16: while ((token = this.lexer.yylex()) != null) {
                if (token.format != Format.FORMAT_SPECIAL) {
                    compiledPattern.add(token);
                    continue;
                }
                c = ((Character)token.data).charValue();
                switch (c) {
                    case 'c': {
                        this.addToPattern(compiledPattern, "a b e H:M:S Y");
                        continue block16;
                    }
                    case 'D': 
                    case 'x': {
                        this.addToPattern(compiledPattern, "m/d/y");
                        continue block16;
                    }
                    case 'F': {
                        this.addToPattern(compiledPattern, "Y-m-d");
                        continue block16;
                    }
                    case 'n': {
                        compiledPattern.add(Token.str("\n"));
                        continue block16;
                    }
                    case 'Q': {
                        if (dateLibrary) {
                            compiledPattern.add(new Token(Format.FORMAT_MICROSEC_EPOCH));
                            continue block16;
                        }
                        compiledPattern.add(Token.str("%Q"));
                        continue block16;
                    }
                    case 'R': {
                        this.addToPattern(compiledPattern, "H:M");
                        continue block16;
                    }
                    case 'r': {
                        this.addToPattern(compiledPattern, "I:M:S p");
                        continue block16;
                    }
                    case 'T': 
                    case 'X': {
                        this.addToPattern(compiledPattern, "H:M:S");
                        continue block16;
                    }
                    case 't': {
                        compiledPattern.add(Token.str("\t"));
                        continue block16;
                    }
                    case 'v': {
                        this.addToPattern(compiledPattern, "e-");
                        if (!dateLibrary) {
                            compiledPattern.add(Token.formatter(new RubyTimeOutputFormatter("^", 0)));
                        }
                        this.addToPattern(compiledPattern, "b-Y");
                        continue block16;
                    }
                    case 'Z': {
                        if (dateLibrary) {
                            compiledPattern.add(Token.zoneOffsetColons(1));
                            continue block16;
                        }
                        compiledPattern.add(new Token(Format.FORMAT_ZONE_ID));
                        continue block16;
                    }
                    case '+': {
                        if (!dateLibrary) {
                            compiledPattern.add(Token.str("%+"));
                            continue block16;
                        }
                        this.addToPattern(compiledPattern, "a b e H:M:S ");
                        compiledPattern.add(Token.zoneOffsetColons(1));
                        this.addToPattern(compiledPattern, " Y");
                        continue block16;
                    }
                }
            }
            return compiledPattern;
            throw new Error("Unknown special char: " + c);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return compiledPattern;
    }

    public ByteList formatToByteList(List<Token> compiledPattern, ZonedDateTime dt) {
        RubyTimeOutputFormatter formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
        ByteList toAppendTo = new ByteList();
        block38: for (Token token : compiledPattern) {
            String output = null;
            long value = 0L;
            FieldType type = FieldType.TEXT;
            Format format = token.getFormat();
            switch (format) {
                case FORMAT_ENCODING: {
                    toAppendTo.setEncoding((Encoding)token.getData());
                    continue block38;
                }
                case FORMAT_OUTPUT: {
                    formatter = (RubyTimeOutputFormatter)token.getData();
                    continue block38;
                }
                case FORMAT_STRING: {
                    output = token.getData().toString();
                    break;
                }
                case FORMAT_WEEK_LONG: {
                    int v = (dt.getDayOfWeek().getValue() + 1) % 8;
                    if (v == 0) {
                        ++v;
                    }
                    output = FORMAT_SYMBOLS.getWeekdays()[v];
                    break;
                }
                case FORMAT_WEEK_SHORT: {
                    int v = (dt.getDayOfWeek().getValue() + 1) % 8;
                    if (v == 0) {
                        ++v;
                    }
                    output = FORMAT_SYMBOLS.getShortWeekdays()[v];
                    break;
                }
                case FORMAT_MONTH_LONG: {
                    output = FORMAT_SYMBOLS.getMonths()[dt.getMonthValue() - 1];
                    break;
                }
                case FORMAT_MONTH_SHORT: {
                    output = FORMAT_SYMBOLS.getShortMonths()[dt.getMonthValue() - 1];
                    break;
                }
                case FORMAT_DAY: {
                    type = FieldType.NUMERIC2;
                    value = dt.getDayOfMonth();
                    break;
                }
                case FORMAT_DAY_S: {
                    type = FieldType.NUMERIC2BLANK;
                    value = dt.getDayOfMonth();
                    break;
                }
                case FORMAT_HOUR: {
                    type = FieldType.NUMERIC2;
                    value = dt.getHour();
                    break;
                }
                case FORMAT_HOUR_BLANK: {
                    type = FieldType.NUMERIC2BLANK;
                    value = dt.getHour();
                    break;
                }
                case FORMAT_HOUR_M: 
                case FORMAT_HOUR_S: {
                    value = dt.getHour();
                    if (value == 0L) {
                        value = 12L;
                    } else if (value > 12L) {
                        value -= 12L;
                    }
                    type = format == Format.FORMAT_HOUR_M ? FieldType.NUMERIC2 : FieldType.NUMERIC2BLANK;
                    break;
                }
                case FORMAT_DAY_YEAR: {
                    type = FieldType.NUMERIC3;
                    value = dt.getDayOfYear();
                    break;
                }
                case FORMAT_MINUTES: {
                    type = FieldType.NUMERIC2;
                    value = dt.getMinute();
                    break;
                }
                case FORMAT_MONTH: {
                    type = FieldType.NUMERIC2;
                    value = dt.getMonthValue();
                    break;
                }
                case FORMAT_MERIDIAN: {
                    output = dt.getHour() < 12 ? "AM" : "PM";
                    break;
                }
                case FORMAT_MERIDIAN_LOWER_CASE: {
                    output = dt.getHour() < 12 ? "am" : "pm";
                    break;
                }
                case FORMAT_SECONDS: {
                    type = FieldType.NUMERIC2;
                    value = dt.getSecond();
                    break;
                }
                case FORMAT_WEEK_YEAR_M: {
                    type = FieldType.NUMERIC2;
                    value = this.formatWeekOfYear(dt, 2);
                    break;
                }
                case FORMAT_WEEK_YEAR_S: {
                    type = FieldType.NUMERIC2;
                    value = this.formatWeekOfYear(dt, 1);
                    break;
                }
                case FORMAT_DAY_WEEK: {
                    type = FieldType.NUMERIC;
                    value = dt.getDayOfWeek().getValue() % 7;
                    break;
                }
                case FORMAT_DAY_WEEK2: {
                    type = FieldType.NUMERIC;
                    value = dt.getDayOfWeek().getValue();
                    break;
                }
                case FORMAT_YEAR_LONG: {
                    value = dt.getYear();
                    type = value >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                    break;
                }
                case FORMAT_YEAR_SHORT: {
                    type = FieldType.NUMERIC2;
                    value = dt.getYear() % 100;
                    break;
                }
                case FORMAT_COLON_ZONE_OFF: {
                    value = dt.getOffset().getTotalSeconds();
                    int colons = (Integer)token.getData();
                    output = this.formatZone(colons, (int)value, formatter);
                    break;
                }
                case FORMAT_ZONE_ID: {
                    output = this.getRubyTimeZoneName(dt);
                    break;
                }
                case FORMAT_CENTURY: {
                    type = FieldType.NUMERIC;
                    value = dt.getYear() / 100;
                    break;
                }
                case FORMAT_EPOCH: {
                    type = FieldType.NUMERIC;
                    value = dt.toInstant().getEpochSecond();
                    break;
                }
                case FORMAT_WEEK_WEEKYEAR: {
                    type = FieldType.NUMERIC2;
                    value = dt.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
                    break;
                }
                case FORMAT_MILLISEC: 
                case FORMAT_NANOSEC: {
                    int defaultWidth = format == Format.FORMAT_NANOSEC ? 9 : 3;
                    int width = formatter.getWidth(defaultWidth);
                    output = RubyTimeOutputFormatter.formatNumber(dt.getNano(), 9, '0');
                    if (width < output.length()) {
                        output = output.substring(0, width);
                    } else {
                        while (output.length() < width) {
                            output = output + "0";
                        }
                    }
                    formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
                    break;
                }
                case FORMAT_WEEKYEAR: {
                    value = GregorianCalendar.from(dt).getWeekYear();
                    type = value >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                    break;
                }
                case FORMAT_WEEKYEAR_SHORT: {
                    value = GregorianCalendar.from(dt).getWeekYear() % 100;
                    type = FieldType.NUMERIC2;
                    break;
                }
                case FORMAT_MICROSEC_EPOCH: {
                    type = FieldType.NUMERIC;
                    Instant instant = dt.toInstant();
                    value = instant.getEpochSecond() * 1000L + (long)(instant.getNano() / 1000000);
                    break;
                }
                case FORMAT_SPECIAL: {
                    throw new Error("FORMAT_SPECIAL is a special token only for the lexer.");
                }
            }
            try {
                output = formatter.format(output, value, type);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new RaiseException(this.context.getCoreExceptions().errnoError(Errno.ERANGE.intValue(), "strftime", this.currentNode));
            }
            formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
            toAppendTo.append(output.getBytes(EncodingManager.charsetForEncoding(toAppendTo.getEncoding())));
        }
        return toAppendTo;
    }

    private int formatWeekOfYear(ZonedDateTime dt, int firstDayOfWeek) {
        GregorianCalendar dtCalendar = GregorianCalendar.from(dt);
        dtCalendar.setFirstDayOfWeek(firstDayOfWeek);
        dtCalendar.setMinimalDaysInFirstWeek(7);
        int value = dtCalendar.get(3);
        if ((value == 52 || value == 53) && dtCalendar.get(2) == 0) {
            value = 0;
        }
        return value;
    }

    private String formatZone(int colons, int value, RubyTimeOutputFormatter formatter) {
        int seconds = Math.abs(value);
        int hours = seconds / 3600;
        int minutes = (seconds %= 3600) / 60;
        seconds %= 60;
        if (value < 0 && hours != 0) {
            hours = -hours;
        }
        String mm = RubyTimeOutputFormatter.formatNumber(minutes, 2, '0');
        String ss = RubyTimeOutputFormatter.formatNumber(seconds, 2, '0');
        char padder = formatter.getPadder('0');
        int defaultWidth = -1;
        String after = null;
        switch (colons) {
            case 0: {
                defaultWidth = 5;
                after = mm;
                break;
            }
            case 1: {
                defaultWidth = 6;
                after = ":" + mm;
                break;
            }
            case 2: {
                defaultWidth = 9;
                after = ":" + mm + ":" + ss;
                break;
            }
            case 3: {
                StringBuilder sb = new StringBuilder();
                if (minutes != 0 || seconds != 0) {
                    sb.append(":").append(mm);
                }
                if (seconds != 0) {
                    sb.append(":").append(ss);
                }
                after = sb.toString();
                defaultWidth = after.length() + 3;
            }
        }
        int minWidth = defaultWidth - 1;
        int width = formatter.getWidth(defaultWidth);
        if (width < minWidth) {
            width = minWidth;
        }
        String before = RubyTimeOutputFormatter.formatSignedNumber(hours, width -= after.length(), padder);
        if (value < 0 && hours == 0) {
            before = before.replace('+', '-');
        }
        return before + after;
    }

    public String getRubyTimeZoneName(ZonedDateTime dt) {
        return RubyDateFormatter.getRubyTimeZoneName(this.getEnvTimeZone().toString(), dt);
    }

    private Object getEnvTimeZone() {
        return DebugHelpers.eval(this.context, "Time.now.zone", new Object[0]);
    }

    public static String getRubyTimeZoneName(String envTZ, ZonedDateTime dt) {
        if (SHORT_STD_TZNAME.containsKey(envTZ) && !dt.getOffset().getRules().isDaylightSavings(dt.toInstant())) {
            return SHORT_STD_TZNAME.get(envTZ);
        }
        if (SHORT_DL_TZNAME.containsKey(envTZ) && dt.getOffset().getRules().isDaylightSavings(dt.toInstant())) {
            return SHORT_DL_TZNAME.get(envTZ);
        }
        String zone = dt.getZone().getId();
        Matcher offsetMatcher = TIME_OFFSET_PATTERN.matcher(zone);
        if (offsetMatcher.matches()) {
            if (zone.equals("+00:00")) {
                zone = "UTC";
            } else {
                zone = dt.getZone().getId();
                if (zone == null) {
                    zone = "";
                }
            }
        }
        return zone;
    }

    public static final Map<String, String> map(String ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>(keyValues.length / 2);
        int i = 0;
        while (i < keyValues.length) {
            map.put(keyValues[i++], keyValues[i++]);
        }
        return map;
    }

    static enum FieldType {
        NUMERIC('0', 0),
        NUMERIC2('0', 2),
        NUMERIC2BLANK(' ', 2),
        NUMERIC3('0', 3),
        NUMERIC4('0', 4),
        NUMERIC5('0', 5),
        TEXT(' ', 0);

        char defaultPadder;
        int defaultWidth;

        private FieldType(char padder, int width) {
            this.defaultPadder = padder;
            this.defaultWidth = width;
        }
    }

    public static class Token {
        private final Format format;
        private final Object data;

        protected Token(Format format) {
            this(format, null);
        }

        protected Token(Format formatString, Object data) {
            this.format = formatString;
            this.data = data;
        }

        public static Token str(String str) {
            return new Token(Format.FORMAT_STRING, str);
        }

        public static Token format(char c) {
            return CONVERSION2TOKEN[c];
        }

        public static Token zoneOffsetColons(int colons) {
            return new Token(Format.FORMAT_COLON_ZONE_OFF, colons);
        }

        public static Token special(char c) {
            return new Token(Format.FORMAT_SPECIAL, Character.valueOf(c));
        }

        public static Token formatter(RubyTimeOutputFormatter formatter) {
            return new Token(Format.FORMAT_OUTPUT, formatter);
        }

        public Object getData() {
            return this.data;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return "<Token " + (Object)((Object)this.format) + " " + this.data + ">";
        }
    }

    static enum Format {
        FORMAT_ENCODING,
        FORMAT_STRING,
        FORMAT_OUTPUT,
        FORMAT_SPECIAL,
        FORMAT_WEEK_LONG('A'),
        FORMAT_WEEK_SHORT('a'),
        FORMAT_MONTH_LONG('B'),
        FORMAT_MONTH_SHORT('b', 'h'),
        FORMAT_CENTURY('C'),
        FORMAT_DAY('d'),
        FORMAT_DAY_S('e'),
        FORMAT_WEEKYEAR('G'),
        FORMAT_WEEKYEAR_SHORT('g'),
        FORMAT_HOUR('H'),
        FORMAT_HOUR_M('I'),
        FORMAT_DAY_YEAR('j'),
        FORMAT_HOUR_BLANK('k'),
        FORMAT_MILLISEC('L'),
        FORMAT_HOUR_S('l'),
        FORMAT_MINUTES('M'),
        FORMAT_MONTH('m'),
        FORMAT_NANOSEC('N'),
        FORMAT_MERIDIAN_LOWER_CASE('P'),
        FORMAT_MERIDIAN('p'),
        FORMAT_SECONDS('S'),
        FORMAT_EPOCH('s'),
        FORMAT_WEEK_YEAR_S('U'),
        FORMAT_DAY_WEEK2('u'),
        FORMAT_WEEK_WEEKYEAR('V'),
        FORMAT_WEEK_YEAR_M('W'),
        FORMAT_DAY_WEEK('w'),
        FORMAT_YEAR_LONG('Y'),
        FORMAT_YEAR_SHORT('y'),
        FORMAT_COLON_ZONE_OFF,
        FORMAT_ZONE_ID,
        FORMAT_MICROSEC_EPOCH;


        private Format() {
        }

        private Format(char conversion) {
            CONVERSION2TOKEN[conversion] = new Token(this);
        }

        private Format(char conversion, char alias) {
            this(conversion);
            CONVERSION2TOKEN[alias] = CONVERSION2TOKEN[conversion];
        }
    }
}

