/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.object.DynamicObject;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;

public class FrozenStrings {
    private final RubyContext context;
    private final Map<RopeHolder, DynamicObject> frozenStrings = new WeakHashMap<RopeHolder, DynamicObject>();

    public FrozenStrings(RubyContext context) {
        this.context = context;
    }

    public synchronized DynamicObject getFrozenString(Rope rope) {
        assert (this.context.getRopeTable().contains(rope));
        RopeHolder holder = new RopeHolder(rope);
        DynamicObject string = this.frozenStrings.get(holder);
        if (string == null) {
            string = StringOperations.createString(this.context, rope);
            string.define((Object)Layouts.FROZEN_IDENTIFIER, (Object)true);
            this.frozenStrings.put(holder, string);
        }
        return string;
    }

    private static class RopeHolder {
        private final Rope rope;

        public RopeHolder(Rope rope) {
            this.rope = rope;
        }

        public Rope getRope() {
            return this.rope;
        }

        public int hashCode() {
            return this.rope.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RopeHolder) {
                RopeHolder other = (RopeHolder)o;
                return this.rope.getEncoding() == other.getRope().getEncoding() && this.rope.equals(other.getRope());
            }
            return false;
        }
    }
}

