/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.algorithms.Randomizer;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.RopeOperations;

public abstract class RandomizerPrimitiveNodes {
    @CompilerDirectives.TruffleBoundary
    private static int randomInt(Randomizer randomizer) {
        return randomizer.genrandInt32();
    }

    @Primitive(name="randomizer_bytes", lowerFixnum={1})
    public static abstract class RandomizerBytesPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject genRandBytes(DynamicObject randomizer, int length) {
            int i;
            int r;
            Randomizer random = Layouts.RANDOMIZER.getRandomizer(randomizer);
            byte[] bytes = new byte[length];
            int idx = 0;
            while (length >= 4) {
                r = random.genrandInt32();
                for (i = 0; i < 4; ++i) {
                    bytes[idx++] = (byte)(r & 0xFF);
                    r >>>= 8;
                }
                length -= 4;
            }
            if (length > 0) {
                r = random.genrandInt32();
                for (i = 0; i < length; ++i) {
                    bytes[idx++] = (byte)(r & 0xFF);
                    r >>>= 8;
                }
            }
            return this.createString(RopeOperations.create(bytes, (Encoding)ASCIIEncoding.INSTANCE, CodeRange.CR_UNKNOWN));
        }
    }

    @Primitive(name="randomizer_gen_seed")
    public static abstract class RandomizerGenSeedPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        private static final Random RANDOM = new SecureRandom();
        private static final int DEFAULT_SEED_CNT = 4;

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject randomizerGenSeed(DynamicObject randomizerClass) {
            BigInteger seed = RandomizerGenSeedPrimitiveNode.randomSeedBigInteger(RANDOM);
            return this.createBignum(seed);
        }

        public static BigInteger randomSeedBigInteger(Random random) {
            byte[] seed = new byte[16];
            random.nextBytes(seed);
            return new BigInteger(seed).abs();
        }
    }

    @Primitive(name="randomizer_rand_int")
    public static abstract class RandomizerRandIntPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public int randomizerRandInt(DynamicObject randomizer, int limit) {
            Randomizer r = Layouts.RANDOMIZER.getRandomizer(randomizer);
            return (int)RandomizerRandIntPrimitiveNode.randInt(r, limit);
        }

        @Specialization
        public long randomizerRandInt(DynamicObject randomizer, long limit) {
            Randomizer r = Layouts.RANDOMIZER.getRandomizer(randomizer);
            return RandomizerRandIntPrimitiveNode.randInt(r, limit);
        }

        @Specialization(guards={"isRubyBignum(limit)"})
        public Object randomizerRandInt(DynamicObject randomizer, DynamicObject limit, @Cached(value="new()") FixnumOrBignumNode fixnumOrBignum) {
            Randomizer r = Layouts.RANDOMIZER.getRandomizer(randomizer);
            return fixnumOrBignum.fixnumOrBignum(RandomizerRandIntPrimitiveNode.randLimitedBignum(r, Layouts.BIGNUM.getValue(limit)));
        }

        @CompilerDirectives.TruffleBoundary
        protected static long randInt(Randomizer r, long limit) {
            return RandomizerRandIntPrimitiveNode.randLimitedFixnumInner(r, limit);
        }

        public static long randLimitedFixnumInner(Randomizer randomizer, long limit) {
            long val;
            if (limit == 0L) {
                val = 0L;
            } else {
                long mask = RandomizerRandIntPrimitiveNode.makeMask(limit);
                block0: while (true) {
                    val = 0L;
                    for (int i = 1; 0 <= i; --i) {
                        if ((mask >>> i * 32 & 0xFFFFFFFFL) != 0L) {
                            val |= ((long)randomizer.genrandInt32() & 0xFFFFFFFFL) << i * 32;
                            val &= mask;
                        }
                        if (limit < val) continue block0;
                    }
                    break;
                }
            }
            return val;
        }

        private static BigInteger randLimitedBignum(Randomizer randomizer, BigInteger limit) {
            byte[] buf = limit.toByteArray();
            byte[] bytes = new byte[buf.length];
            int len = (buf.length + 3) / 4;
            block0: while (true) {
                long mask = 0L;
                boolean boundary = true;
                for (int idx = len - 1; 0 <= idx; --idx) {
                    long rnd;
                    long lim = (long)RandomizerRandIntPrimitiveNode.getIntBigIntegerBuffer(buf, idx) & 0xFFFFFFFFL;
                    long l = mask = mask != 0L ? 0xFFFFFFFFL : RandomizerRandIntPrimitiveNode.makeMask(lim);
                    if (mask != 0L) {
                        rnd = (long)randomizer.genrandInt32() & 0xFFFFFFFFL & mask;
                        if (boundary) {
                            if (lim < rnd) continue block0;
                            if (rnd < lim) {
                                boundary = false;
                            }
                        }
                    } else {
                        rnd = 0L;
                    }
                    RandomizerRandIntPrimitiveNode.setIntBigIntegerBuffer(bytes, idx, (int)rnd);
                }
                break;
            }
            return new BigInteger(bytes);
        }

        private static int getIntBigIntegerBuffer(byte[] src, int loc) {
            int v = 0;
            int idx = src.length - loc * 4 - 1;
            if (idx >= 0) {
                v |= src[idx--] & 0xFF;
                if (idx >= 0) {
                    v |= (src[idx--] & 0xFF) << 8;
                    if (idx >= 0) {
                        v |= (src[idx--] & 0xFF) << 16;
                        if (idx >= 0) {
                            v |= (src[idx--] & 0xFF) << 24;
                        }
                    }
                }
            }
            return v;
        }

        private static void setIntBigIntegerBuffer(byte[] dest, int loc, int value) {
            int idx = dest.length - loc * 4 - 1;
            if (idx >= 0) {
                dest[idx--] = (byte)(value & 0xFF);
                if (idx >= 0) {
                    dest[idx--] = (byte)(value >> 8 & 0xFF);
                    if (idx >= 0) {
                        dest[idx--] = (byte)(value >> 16 & 0xFF);
                        if (idx >= 0) {
                            dest[idx--] = (byte)(value >> 24 & 0xFF);
                        }
                    }
                }
            }
        }

        private static long makeMask(long x) {
            x |= x >>> 1;
            x |= x >>> 2;
            x |= x >>> 4;
            x |= x >>> 8;
            x |= x >>> 16;
            x |= x >>> 32;
            return x;
        }
    }

    @Primitive(name="randomizer_rand_float")
    public static abstract class RandomizerRandFloatPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public double randomizerRandFloat(DynamicObject randomizer) {
            Randomizer r = Layouts.RANDOMIZER.getRandomizer(randomizer);
            int a = RandomizerPrimitiveNodes.randomInt(r) >>> 5;
            int b = RandomizerPrimitiveNodes.randomInt(r) >>> 6;
            return ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
        }
    }

    @Primitive(name="randomizer_seed")
    public static abstract class RandomizerSeedPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        public static int N = 624;

        @Specialization(guards={"isRubyBignum(seed)"})
        public DynamicObject randomizerSeed(DynamicObject randomizer, DynamicObject seed) {
            Layouts.RANDOMIZER.setRandomizer(randomizer, RandomizerSeedPrimitiveNode.randomFromBigInteger(Layouts.BIGNUM.getValue(seed)));
            return randomizer;
        }

        @Specialization
        public DynamicObject randomizerSeed(DynamicObject randomizer, long seed) {
            Layouts.RANDOMIZER.setRandomizer(randomizer, RandomizerSeedPrimitiveNode.randomFromLong(seed));
            return randomizer;
        }

        @CompilerDirectives.TruffleBoundary
        protected static Randomizer randomFromLong(long seed) {
            return Randomizer.randomFromLong(seed);
        }

        @CompilerDirectives.TruffleBoundary
        public static Randomizer randomFromBigInteger(BigInteger big) {
            if (big.signum() < 0) {
                big = big.abs();
            }
            byte[] buf = big.toByteArray();
            int buflen = buf.length;
            if (buf[0] == 0) {
                --buflen;
            }
            int len = Math.min((buflen + 3) / 4, N);
            int[] ints = RandomizerSeedPrimitiveNode.bigEndianToInts(buf, len);
            if (len <= 1) {
                return new Randomizer(ints[0]);
            }
            return new Randomizer(ints);
        }

        private static int[] bigEndianToInts(byte[] buf, int initKeyLen) {
            int[] initKey = new int[initKeyLen];
            for (int idx = 0; idx < initKey.length; ++idx) {
                initKey[idx] = RandomizerSeedPrimitiveNode.getIntBigIntegerBuffer(buf, idx);
            }
            return initKey;
        }

        static int getIntBigIntegerBuffer(byte[] src, int loc) {
            int v = 0;
            int idx = src.length - loc * 4 - 1;
            if (idx >= 0) {
                v |= src[idx--] & 0xFF;
                if (idx >= 0) {
                    v |= (src[idx--] & 0xFF) << 8;
                    if (idx >= 0) {
                        v |= (src[idx--] & 0xFF) << 16;
                        if (idx >= 0) {
                            v |= (src[idx--] & 0xFF) << 24;
                        }
                    }
                }
            }
            return v;
        }
    }

    @Primitive(name="randomizer_allocate", needsSelf=false)
    public static abstract class RandomizerAllocatePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject randomizerAllocate() {
            return Layouts.RANDOMIZER.createRandomizer(this.coreLibrary().getRandomizerFactory(), new Randomizer());
        }
    }
}

